/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.http;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.CdpHTTPException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.http.RetryChecker;
import com.cloudera.cdp.shaded.com.google.common.collect.ImmutableSet;
import java.util.Set;

public class HttpCodesRetryChecker
implements RetryChecker {
    public static final ImmutableSet<Integer> DEFAULT_RETRY_CODES = ImmutableSet.of(Integer.valueOf(503), Integer.valueOf(429));
    private final ImmutableSet<Integer> retriableCodes;

    public HttpCodesRetryChecker(Set<Integer> httpCodes) {
        ValidationUtils.checkNotNullAndThrow(httpCodes);
        ValidationUtils.checkArgumentAndThrow(httpCodes.size() > 0);
        this.retriableCodes = ImmutableSet.copyOf(httpCodes);
    }

    @Override
    public boolean shouldRetry(int attempts, CdpClientException exception) {
        ValidationUtils.checkNotNullAndThrow(exception);
        ValidationUtils.checkArgumentAndThrow(attempts >= 1);
        if (exception instanceof CdpHTTPException) {
            return this.retriableCodes.contains(((CdpHTTPException)exception).getHttpCode());
        }
        return false;
    }
}

