/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.shaded.org.bouncycastle.asn1.sec;

import com.cloudera.cdp.shaded.org.bouncycastle.asn1.ASN1Encodable;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.ASN1Integer;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.ASN1Object;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.ASN1OctetString;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.ASN1Primitive;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.ASN1Sequence;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.DERBitString;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.DEROctetString;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.DERSequence;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.DERTaggedObject;
import com.cloudera.cdp.shaded.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.util.Enumeration;

public class ECPrivateKey
extends ASN1Object {
    private ASN1Sequence seq;

    private ECPrivateKey(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
    }

    public static ECPrivateKey getInstance(Object object) {
        if (object instanceof ECPrivateKey) {
            return (ECPrivateKey)object;
        }
        if (object != null) {
            return new ECPrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ECPrivateKey(BigInteger bigInteger) {
        this(bigInteger.bitLength(), bigInteger);
    }

    public ECPrivateKey(int n, BigInteger bigInteger) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((n + 7) / 8, bigInteger);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(new ASN1Integer(1L));
        aSN1EncodableVector.add(new DEROctetString(byArray));
        this.seq = new DERSequence(aSN1EncodableVector);
    }

    public ECPrivateKey(BigInteger bigInteger, ASN1Encodable aSN1Encodable) {
        this(bigInteger, null, aSN1Encodable);
    }

    public ECPrivateKey(BigInteger bigInteger, DERBitString dERBitString, ASN1Encodable aSN1Encodable) {
        this(bigInteger.bitLength(), bigInteger, dERBitString, aSN1Encodable);
    }

    public ECPrivateKey(int n, BigInteger bigInteger, ASN1Encodable aSN1Encodable) {
        this(n, bigInteger, null, aSN1Encodable);
    }

    public ECPrivateKey(int n, BigInteger bigInteger, DERBitString dERBitString, ASN1Encodable aSN1Encodable) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((n + 7) / 8, bigInteger);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(4);
        aSN1EncodableVector.add(new ASN1Integer(1L));
        aSN1EncodableVector.add(new DEROctetString(byArray));
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, aSN1Encodable));
        }
        if (dERBitString != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, dERBitString));
        }
        this.seq = new DERSequence(aSN1EncodableVector);
    }

    public BigInteger getKey() {
        ASN1OctetString aSN1OctetString = (ASN1OctetString)this.seq.getObjectAt(1);
        return new BigInteger(1, aSN1OctetString.getOctets());
    }

    public DERBitString getPublicKey() {
        return (DERBitString)this.getObjectInTag(1);
    }

    public ASN1Primitive getParameters() {
        return this.getObjectInTag(0);
    }

    private ASN1Primitive getObjectInTag(int n) {
        Enumeration enumeration = this.seq.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject;
            ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
            if (!(aSN1Encodable instanceof ASN1TaggedObject) || (aSN1TaggedObject = (ASN1TaggedObject)aSN1Encodable).getTagNo() != n) continue;
            return aSN1TaggedObject.getObject().toASN1Primitive();
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

