/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.shaded.org.bouncycastle.pqc.crypto.lms;

import com.cloudera.cdp.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.pqc.crypto.lms.LMS;
import com.cloudera.cdp.shaded.org.bouncycastle.pqc.crypto.lms.LMSKeyGenerationParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import java.security.SecureRandom;

public class LMSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    LMSKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (LMSKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom secureRandom = this.param.getRandom();
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = new byte[32];
        secureRandom.nextBytes(byArray2);
        LMSPrivateKeyParameters lMSPrivateKeyParameters = LMS.generateKeys(this.param.getParameters().getLMSigParam(), this.param.getParameters().getLMOTSParam(), 0, byArray, byArray2);
        return new AsymmetricCipherKeyPair(lMSPrivateKeyParameters.getPublicKey(), lMSPrivateKeyParameters);
    }
}

