/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncBufferedResponse;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncResponse;
import com.azure.core.util.Context;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.ByteString;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class OkHttpAsyncHttpClient
implements HttpClient {
    final OkHttpClient httpClient;
    private static final Mono<ByteString> EMPTY_BYTE_STRING_MONO = Mono.just((Object)ByteString.EMPTY);

    OkHttpAsyncHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = context.getData((Object)"azure-eagerly-read-response").orElse(false);
        return Mono.create(sink -> sink.onRequest(value -> OkHttpAsyncHttpClient.toOkHttpRequest(request).subscribe(okHttpRequest -> {
            try {
                Call call = this.httpClient.newCall(okHttpRequest);
                call.enqueue((Callback)new OkHttpCallback((MonoSink<HttpResponse>)sink, request, eagerlyReadResponse));
                sink.onCancel(() -> ((Call)call).cancel());
            }
            catch (Exception ex) {
                sink.error((Throwable)ex);
            }
        }, arg_0 -> ((MonoSink)sink).error(arg_0))));
    }

    private static Mono<Request> toOkHttpRequest(HttpRequest request) {
        Request.Builder requestBuilder = new Request.Builder().url(request.getUrl());
        if (request.getHeaders() != null) {
            for (HttpHeader hdr : request.getHeaders()) {
                hdr.getValuesList().forEach(value -> requestBuilder.addHeader(hdr.getName(), value));
            }
        }
        if (request.getHttpMethod() == HttpMethod.GET) {
            return Mono.just((Object)requestBuilder.get().build());
        }
        if (request.getHttpMethod() == HttpMethod.HEAD) {
            return Mono.just((Object)requestBuilder.head().build());
        }
        return OkHttpAsyncHttpClient.toOkHttpRequestBody((Flux<ByteBuffer>)request.getBody(), request.getHeaders()).map(okhttpRequestBody -> requestBuilder.method(request.getHttpMethod().toString(), okhttpRequestBody).build());
    }

    private static Mono<RequestBody> toOkHttpRequestBody(Flux<ByteBuffer> bbFlux, HttpHeaders headers) {
        Mono<ByteString> bsMono = bbFlux == null ? EMPTY_BYTE_STRING_MONO : OkHttpAsyncHttpClient.toByteString(bbFlux);
        return bsMono.map(bs -> {
            String contentType = headers.getValue("Content-Type");
            MediaType mediaType = contentType == null ? null : MediaType.parse((String)contentType);
            return RequestBody.create((ByteString)bs, (MediaType)mediaType);
        });
    }

    private static Mono<ByteString> toByteString(Flux<ByteBuffer> bbFlux) {
        Objects.requireNonNull(bbFlux, "'bbFlux' cannot be null.");
        return Mono.using(Buffer::new, buffer -> bbFlux.reduce(buffer, (b, byteBuffer) -> {
            try {
                b.write(byteBuffer);
                return b;
            }
            catch (IOException ioe) {
                throw Exceptions.propagate((Throwable)ioe);
            }
        }).map(b -> ByteString.of((byte[])b.readByteArray())), Buffer::clear).switchIfEmpty(EMPTY_BYTE_STRING_MONO);
    }

    private static class OkHttpCallback
    implements Callback {
        private final MonoSink<HttpResponse> sink;
        private final HttpRequest request;
        private final boolean eagerlyReadResponse;

        OkHttpCallback(MonoSink<HttpResponse> sink, HttpRequest request, boolean eagerlyReadResponse) {
            this.sink = sink;
            this.request = request;
            this.eagerlyReadResponse = eagerlyReadResponse;
        }

        public void onFailure(Call call, IOException e) {
            this.sink.error((Throwable)e);
        }

        public void onResponse(Call call, Response response) {
            if (this.eagerlyReadResponse) {
                ResponseBody body = response.body();
                if (Objects.nonNull(body)) {
                    try {
                        byte[] bytes = body.bytes();
                        body.close();
                        this.sink.success((Object)new OkHttpAsyncBufferedResponse(response, this.request, bytes));
                    }
                    catch (IOException ex) {
                        this.sink.error((Throwable)ex);
                    }
                } else {
                    this.sink.success((Object)new OkHttpAsyncResponse(response, this.request));
                }
            } else {
                this.sink.success((Object)new OkHttpAsyncResponse(response, this.request));
            }
        }
    }
}

