/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.metering;

import com.cloudera.cdp.authentication.credentials.BasicCdpCredentials;
import com.cloudera.cdp.authentication.credentials.CdpCredentials;
import com.cloudera.cdp.authentication.credentials.CdpCredentialsProvider;
import com.cloudera.cdp.authentication.credentials.StaticCdpCredentialsProvider;
import com.cloudera.cdp.dbus.api.DbusClient;
import com.cloudera.cdp.dbus.api.DbusClientBuilder;
import com.cloudera.cdp.dbus.model.Header;
import com.cloudera.cdp.dbus.model.PutRecordRequest;
import com.cloudera.cdp.dbus.model.Record;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.cloudera.naaf.metering.DbusNaafInvocation;
import com.cloudera.naaf.metering.Invocation;
import com.cloudera.naaf.metering.MeteringException;
import com.cloudera.naaf.metering.MeteringPublisher;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbusMeteringPublisher
implements MeteringPublisher {
    private static final Logger logger = LoggerFactory.getLogger(DbusMeteringPublisher.class);
    private static final int VERSION = 1;
    private static final String STREAM_NAME = "NaafMeter";
    private static final String DEFAULT_STREAM_APP_NAME = "NaafMeter";
    private static final String QUALIFIED_STREAM_NAME_FORMAT = "%s-%s-%s";
    private static final String ACCESS_KEY_ENV_VAR = "DF_ACCESS_KEY";
    private static final String PRIVATE_KEY_ENV_VAR = "DF_PRIVATE_KEY";
    private static final String STREAM_APP_NAME_ENV_VAR = "NAAF_STREAM_APP";
    private static final String DBUS_CLUSTER_ENV_VAR = "DBUS_CLUSTER";
    private static final String APPLICATION_HEADER_NAME = "Applications";
    private static final String APPLICATION_HEADER_VALUE = "DataFlow Functions";
    private static final String STREAM_APP_HEADER_NAME = "@naafmeter-app";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private DbusClient dbusClient;
    private String accessKeyId;
    private String streamName;
    private String streamAppName;

    public void initialize() {
        this.accessKeyId = System.getenv(ACCESS_KEY_ENV_VAR);
        String privateKey = System.getenv(PRIVATE_KEY_ENV_VAR);
        String streamAppName = System.getenv(STREAM_APP_NAME_ENV_VAR);
        String dbusClusterEnvVarValue = System.getenv(DBUS_CLUSTER_ENV_VAR);
        DbusCluster dbusCluster = dbusClusterEnvVarValue != null ? DbusCluster.valueOf(dbusClusterEnvVarValue.toUpperCase()) : DbusCluster.PROD;
        this.streamAppName = streamAppName != null ? this.getQualifiedStreamAppName(dbusCluster.environment, dbusCluster.cluster, streamAppName) : this.getQualifiedStreamAppName(dbusCluster.environment, dbusCluster.cluster, "NaafMeter");
        this.streamName = this.getQualifiedStreamName(dbusCluster.environment, dbusCluster.cluster);
        BasicCdpCredentials credentials = new BasicCdpCredentials(this.accessKeyId, privateKey);
        this.dbusClient = ((DbusClientBuilder)((DbusClientBuilder)DbusClientBuilder.defaultBuilder().withCredentials((CdpCredentialsProvider)new StaticCdpCredentialsProvider((CdpCredentials)credentials))).withEndPoint(dbusCluster.dbusEndpoint)).build();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public synchronized void publish(Invocation invocation) {
        try {
            DbusNaafInvocation dbusNaafInvocation = this.getNaafInvocation(invocation);
            PutRecordRequest putRecordRequest = this.createRequest(this.getPayload(dbusNaafInvocation), dbusNaafInvocation.getFunctionId());
            logger.debug("Submitting to metering service: " + putRecordRequest);
            this.dbusClient.putRecord(putRecordRequest);
            logger.debug("Successfully submitted billing invocation with partition key {} to metering service", (Object)putRecordRequest.getRecord().getPartitionKey());
        }
        catch (Throwable e) {
            logger.error("Failed to submit billing invocation to metering service", e);
            throw new MeteringException("Failed to submit billing invocation to metering service", e, invocation.isSuccessful());
        }
    }

    private DbusNaafInvocation getNaafInvocation(Invocation invocation) {
        DbusNaafInvocation dbusNaafInvocation = new DbusNaafInvocation();
        dbusNaafInvocation.setDurationMillis(invocation.getDuration(TimeUnit.MILLISECONDS));
        dbusNaafInvocation.setFlowCrn(invocation.getFlowCrn());
        dbusNaafInvocation.setFunctionId(invocation.getFunctionId());
        dbusNaafInvocation.setFunctionName(invocation.getFunctionName());
        dbusNaafInvocation.setInvocationId(invocation.getId());
        dbusNaafInvocation.setPlatform(invocation.getCloudPlatform());
        dbusNaafInvocation.setStartTime(invocation.getStartTime().toEpochMilli());
        dbusNaafInvocation.setSuccess(invocation.isSuccessful());
        dbusNaafInvocation.setVersion(1);
        if (invocation.getRegion() == null) {
            dbusNaafInvocation.setRegion("UNKNOWN");
        } else {
            dbusNaafInvocation.setRegion(invocation.getRegion());
        }
        dbusNaafInvocation.setAccessKeyId(this.accessKeyId);
        return dbusNaafInvocation;
    }

    private String getPayload(DbusNaafInvocation dbusNaafInvocation) {
        try {
            return this.objectMapper.writeValueAsString((Object)dbusNaafInvocation);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize billed invocation", e);
        }
    }

    private PutRecordRequest createRequest(String payload, String functionId) {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(this.getHeader(APPLICATION_HEADER_NAME, APPLICATION_HEADER_VALUE));
        headers.add(this.getHeader(STREAM_APP_HEADER_NAME, this.streamAppName));
        PutRecordRequest putRecordRequest = new PutRecordRequest();
        Record record = new Record();
        record.setPayload(Base64.getEncoder().encodeToString(payload.getBytes(StandardCharsets.UTF_8)));
        record.setPayloadSize(Long.valueOf(payload.length()));
        record.setPartitionKey(functionId);
        record.setStreamName(this.streamName);
        record.setHeaders(headers);
        putRecordRequest.setRecord(record);
        return putRecordRequest;
    }

    private Header getHeader(String name, String value) {
        Header header = new Header();
        header.setName(name);
        header.setValue(value);
        return header;
    }

    private String getQualifiedStreamName(String environment, String cluster) {
        return String.format(QUALIFIED_STREAM_NAME_FORMAT, environment, cluster, "NaafMeter");
    }

    private String getQualifiedStreamAppName(String environment, String cluster, String streamAppName) {
        return String.format(QUALIFIED_STREAM_NAME_FORMAT, environment, cluster, streamAppName);
    }

    private static enum DbusCluster {
        PRIV("manowar_dev", "mow-priv", "https://dbusapi.sigma-dev.cloudera.com:443"),
        DEV("manowar_dev", "mow", "https://dbusapi.sigma-dev.cloudera.com:443"),
        INT("manowar_int", "mow-int", "https://dbusapi.sigma-int.cloudera.com:443"),
        STAGE("manowar_stage", "mow-stage", "https://dbusapi.sigma-stage.cloudera.com:443"),
        PROD("manowar_prod", "mow-prod", "https://dbusapi.us-west-1.sigma.altus.cloudera.com");

        private String environment;
        private String cluster;
        private String dbusEndpoint;

        private DbusCluster(String environment, String cluster, String dbusEndpoint) {
            this.environment = environment;
            this.cluster = cluster;
            this.dbusEndpoint = dbusEndpoint;
        }
    }
}

