/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.metering;

import com.cloudera.naaf.metering.Invocation;
import com.cloudera.naaf.metering.MeteringPublisher;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NopMeteringPublisher
implements MeteringPublisher {
    private static final Logger logger = LoggerFactory.getLogger(NopMeteringPublisher.class);
    private long millis;
    private int invocations;
    private int successful;

    public void initialize() {
    }

    public synchronized void publish(Invocation invocation) {
        this.millis += this.roundDurationToMillis(invocation.getDuration(TimeUnit.NANOSECONDS));
        ++this.invocations;
        if (invocation.isSuccessful()) {
            ++this.successful;
        }
        this.flush();
    }

    private long roundDurationToMillis(long nanos) {
        long millis = nanos / 1000000L;
        long additionalNanos = nanos % (millis * 1000000L);
        if (additionalNanos > 0L) {
            return millis + 1L;
        }
        return millis;
    }

    private synchronized void flush() {
        if (this.invocations == 0) {
            logger.debug("No invocations to report");
            return;
        }
        logger.info("Billing is disabled. Otherwise, billing notification would be sent for: {} invocations, {} of which were successful, for a total of {} milliseconds", new Object[]{this.invocations, this.successful, this.millis});
        this.reset();
    }

    private synchronized void reset() {
        this.invocations = 0;
        this.millis = 0L;
        this.successful = 0;
    }
}

