/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.Trigger;
import software.amazon.awssdk.services.glue.model.TriggerListCopier;
import software.amazon.awssdk.services.glue.model.TriggerNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetTriggersResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetTriggersResponse> {
    private static final SdkField<List<Trigger>> TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Triggers").getter(BatchGetTriggersResponse.getter(BatchGetTriggersResponse::triggers)).setter(BatchGetTriggersResponse.setter(Builder::triggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Triggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Trigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TRIGGERS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TriggersNotFound").getter(BatchGetTriggersResponse.getter(BatchGetTriggersResponse::triggersNotFound)).setter(BatchGetTriggersResponse.setter(Builder::triggersNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggersNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGERS_FIELD, TRIGGERS_NOT_FOUND_FIELD));
    private final List<Trigger> triggers;
    private final List<String> triggersNotFound;

    private BatchGetTriggersResponse(BuilderImpl builder) {
        super(builder);
        this.triggers = builder.triggers;
        this.triggersNotFound = builder.triggersNotFound;
    }

    public final boolean hasTriggers() {
        return this.triggers != null && !(this.triggers instanceof SdkAutoConstructList);
    }

    public final List<Trigger> triggers() {
        return this.triggers;
    }

    public final boolean hasTriggersNotFound() {
        return this.triggersNotFound != null && !(this.triggersNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> triggersNotFound() {
        return this.triggersNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggers() ? this.triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggersNotFound() ? this.triggersNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTriggersResponse)) {
            return false;
        }
        BatchGetTriggersResponse other = (BatchGetTriggersResponse)((Object)obj);
        return this.hasTriggers() == other.hasTriggers() && Objects.equals(this.triggers(), other.triggers()) && this.hasTriggersNotFound() == other.hasTriggersNotFound() && Objects.equals(this.triggersNotFound(), other.triggersNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetTriggersResponse").add("Triggers", this.hasTriggers() ? this.triggers() : null).add("TriggersNotFound", this.hasTriggersNotFound() ? this.triggersNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Triggers": {
                return Optional.ofNullable(clazz.cast(this.triggers()));
            }
            case "TriggersNotFound": {
                return Optional.ofNullable(clazz.cast(this.triggersNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTriggersResponse, T> g) {
        return obj -> g.apply((BatchGetTriggersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Trigger> triggers = DefaultSdkAutoConstructList.getInstance();
        private List<String> triggersNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTriggersResponse model) {
            super(model);
            this.triggers(model.triggers);
            this.triggersNotFound(model.triggersNotFound);
        }

        public final List<Trigger.Builder> getTriggers() {
            List<Trigger.Builder> result = TriggerListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        @Override
        @Transient
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggers(Trigger ... triggers) {
            this.triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggers(Consumer<Trigger.Builder> ... triggers) {
            this.triggers(Stream.of(triggers).map(c -> (Trigger)((Trigger.Builder)Trigger.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTriggersNotFound() {
            if (this.triggersNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.triggersNotFound;
        }

        public final void setTriggersNotFound(Collection<String> triggersNotFound) {
            this.triggersNotFound = TriggerNameListCopier.copy(triggersNotFound);
        }

        @Override
        @Transient
        public final Builder triggersNotFound(Collection<String> triggersNotFound) {
            this.triggersNotFound = TriggerNameListCopier.copy(triggersNotFound);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggersNotFound(String ... triggersNotFound) {
            this.triggersNotFound(Arrays.asList(triggersNotFound));
            return this;
        }

        @Override
        public BatchGetTriggersResponse build() {
            return new BatchGetTriggersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetTriggersResponse> {
        public Builder triggers(Collection<Trigger> var1);

        public Builder triggers(Trigger ... var1);

        public Builder triggers(Consumer<Trigger.Builder> ... var1);

        public Builder triggersNotFound(Collection<String> var1);

        public Builder triggersNotFound(String ... var1);
    }
}

