/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunsRequest;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunsResponse;

public class GetBlueprintRunsPublisher
implements SdkPublisher<GetBlueprintRunsResponse> {
    private final GlueAsyncClient client;
    private final GetBlueprintRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBlueprintRunsPublisher(GlueAsyncClient client, GetBlueprintRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBlueprintRunsPublisher(GlueAsyncClient client, GetBlueprintRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBlueprintRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBlueprintRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetBlueprintRunsResponseFetcher
    implements AsyncPageFetcher<GetBlueprintRunsResponse> {
        private GetBlueprintRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetBlueprintRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetBlueprintRunsResponse> nextPage(GetBlueprintRunsResponse previousPage) {
            if (previousPage == null) {
                return GetBlueprintRunsPublisher.this.client.getBlueprintRuns(GetBlueprintRunsPublisher.this.firstRequest);
            }
            return GetBlueprintRunsPublisher.this.client.getBlueprintRuns((GetBlueprintRunsRequest)((Object)GetBlueprintRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

