/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformsResponse;

public class GetMLTransformsIterable
implements SdkIterable<GetMlTransformsResponse> {
    private final GlueClient client;
    private final GetMlTransformsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetMLTransformsIterable(GlueClient client, GetMlTransformsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetMlTransformsResponseFetcher();
    }

    public Iterator<GetMlTransformsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetMlTransformsResponseFetcher
    implements SyncPageFetcher<GetMlTransformsResponse> {
        private GetMlTransformsResponseFetcher() {
        }

        public boolean hasNextPage(GetMlTransformsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetMlTransformsResponse nextPage(GetMlTransformsResponse previousPage) {
            if (previousPage == null) {
                return GetMLTransformsIterable.this.client.getMLTransforms(GetMLTransformsIterable.this.firstRequest);
            }
            return GetMLTransformsIterable.this.client.getMLTransforms((GetMlTransformsRequest)((Object)GetMLTransformsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

