/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetTriggersRequest;
import software.amazon.awssdk.services.glue.model.GetTriggersResponse;

public class GetTriggersPublisher
implements SdkPublisher<GetTriggersResponse> {
    private final GlueAsyncClient client;
    private final GetTriggersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTriggersPublisher(GlueAsyncClient client, GetTriggersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTriggersPublisher(GlueAsyncClient client, GetTriggersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTriggersResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTriggersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetTriggersResponseFetcher
    implements AsyncPageFetcher<GetTriggersResponse> {
        private GetTriggersResponseFetcher() {
        }

        public boolean hasNextPage(GetTriggersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTriggersResponse> nextPage(GetTriggersResponse previousPage) {
            if (previousPage == null) {
                return GetTriggersPublisher.this.client.getTriggers(GetTriggersPublisher.this.firstRequest);
            }
            return GetTriggersPublisher.this.client.getTriggers((GetTriggersRequest)((Object)GetTriggersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

