/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsResponse;

public class ListDevEndpointsPublisher
implements SdkPublisher<ListDevEndpointsResponse> {
    private final GlueAsyncClient client;
    private final ListDevEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDevEndpointsPublisher(GlueAsyncClient client, ListDevEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDevEndpointsPublisher(GlueAsyncClient client, ListDevEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDevEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDevEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDevEndpointsResponseFetcher
    implements AsyncPageFetcher<ListDevEndpointsResponse> {
        private ListDevEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDevEndpointsResponse> nextPage(ListDevEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListDevEndpointsPublisher.this.client.listDevEndpoints(ListDevEndpointsPublisher.this.firstRequest);
            }
            return ListDevEndpointsPublisher.this.client.listDevEndpoints((ListDevEndpointsRequest)((Object)ListDevEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

