/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.aws.lambda;

import com.cloudera.naaf.StatelessNiFiStateProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;

public class DynamoDBStatelessNiFiStateProvider
implements StatelessNiFiStateProvider {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBStatelessNiFiStateProvider.class);
    private static final String DYNAMODB_STATE_TABLE_VAR = "DYNAMODB_STATE_TABLE";
    private static final String DYNAMODB_BILLING_MODE_VAR = "DYNAMODB_BILLING_MODE";
    private static final String DYNAMODB_WRITE_CAPACITY_UNITS_VAR = "DYNAMODB_WRITE_CAPACITY_UNITS";
    private static final String DYNAMODB_READ_CAPACITY_UNITS_VAR = "DYNAMODB_READ_CAPACITY_UNITS";
    private static final String DEFAULT_STATE_TABLE = "nifi_state";
    public static final String INSTANCE_ID = "instanceId";
    public static final String SCOPE = "scope";
    public static final String STATE = "state";
    private final BillingMode billingMode;
    private final Long readCapacityUnits;
    private final Long writeCapacityUnits;
    private final String tableName;
    private final DynamoDbClient dynamoDbClient;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public DynamoDBStatelessNiFiStateProvider() {
        this.dynamoDbClient = (DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build())).build();
        this.tableName = Optional.ofNullable(System.getenv(DYNAMODB_STATE_TABLE_VAR)).orElse(DEFAULT_STATE_TABLE);
        String billingModeValue = System.getenv(DYNAMODB_BILLING_MODE_VAR);
        if (billingModeValue == null) {
            logger.info("Defaulting DynamoDB Billing Mode to PAY_PER_REQUEST for State Provider");
            this.billingMode = BillingMode.PAY_PER_REQUEST;
        } else {
            this.billingMode = BillingMode.fromValue((String)billingModeValue);
        }
        if (this.billingMode == BillingMode.PROVISIONED) {
            this.readCapacityUnits = this.getCapacityUnits(DYNAMODB_READ_CAPACITY_UNITS_VAR);
            this.writeCapacityUnits = this.getCapacityUnits(DYNAMODB_WRITE_CAPACITY_UNITS_VAR);
        } else {
            this.readCapacityUnits = null;
            this.writeCapacityUnits = null;
        }
        TableStatus tableStatus = this.getTableStatus(this.tableName);
        if (tableStatus == null) {
            tableStatus = this.createTable(this.tableName);
        }
        if ((tableStatus = this.handleTableStatus(this.tableName, tableStatus)) != TableStatus.ACTIVE) {
            logger.error("DynamoDB table {} was in invalid state {}, so NiFi's state cannot be stored or retrieved", (Object)this.tableName, (Object)tableStatus);
            throw new RuntimeException(String.format("DynamoDB table %s was in invalid state %s, so NiFi's state cannot be stored or retrieved", this.tableName, tableStatus));
        }
    }

    private Long getCapacityUnits(String environmentVariableName) {
        String value = System.getenv(environmentVariableName);
        if (value == null) {
            throw new IllegalArgumentException(environmentVariableName + " Environment Variable is required when " + DYNAMODB_BILLING_MODE_VAR + " is PROVISIONED");
        }
        return Long.parseLong(value);
    }

    public void storeState(String instanceId, StatelessNiFiStateProvider.StateScope scope, Map<String, String> state) {
        String stateJson;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        try {
            stateJson = this.objectMapper.writeValueAsString(state);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not write state for instance " + instanceId, e);
        }
        attributes.put(INSTANCE_ID, AttributeValue.builder().s(instanceId).build());
        attributes.put(SCOPE, AttributeValue.builder().s(scope.name()).build());
        attributes.put(STATE, AttributeValue.builder().s(stateJson).build());
        PutItemRequest request = (PutItemRequest)PutItemRequest.builder().tableName(this.tableName).item(attributes).build();
        this.dynamoDbClient.putItem(request);
    }

    public Map<String, String> retrieveState(String instanceId, StatelessNiFiStateProvider.StateScope scope) {
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put(INSTANCE_ID, AttributeValue.builder().s(instanceId).build());
        key.put(SCOPE, AttributeValue.builder().s(scope.name()).build());
        GetItemRequest request = (GetItemRequest)GetItemRequest.builder().tableName(this.tableName).key(key).build();
        GetItemResponse response = this.dynamoDbClient.getItem(request);
        AttributeValue stateValue = (AttributeValue)response.item().get(STATE);
        if (stateValue == null) {
            logger.info("State attribute has not been stored for {}, scope {}", (Object)instanceId, (Object)scope);
            return null;
        }
        String stateJson = stateValue.s();
        try {
            Map state = (Map)this.objectMapper.readValue(stateJson, Map.class);
            return state;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to parse state for instance " + instanceId, e);
        }
    }

    private TableStatus createTable(String instanceId) {
        CreateTableRequest.Builder builder = CreateTableRequest.builder().tableName(instanceId).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName(INSTANCE_ID).attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName(SCOPE).attributeType(ScalarAttributeType.S).build()}).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName(INSTANCE_ID).keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName(SCOPE).keyType(KeyType.RANGE).build()}).billingMode(this.billingMode);
        if (this.billingMode == BillingMode.PROVISIONED) {
            builder.provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(this.readCapacityUnits).writeCapacityUnits(this.writeCapacityUnits).build());
        }
        this.dynamoDbClient.createTable((CreateTableRequest)builder.build());
        return this.getTableStatus(instanceId);
    }

    private TableStatus handleTableStatus(String tableName, TableStatus tableStatus) {
        switch (tableStatus) {
            case CREATING: 
            case UPDATING: {
                while (TableStatus.ACTIVE != tableStatus) {
                    tableStatus = this.getTableStatus(tableName);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Interrupted thread", e);
                    }
                }
                break;
            }
        }
        return tableStatus;
    }

    private TableStatus getTableStatus(String tableName) {
        DescribeTableRequest request = (DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build();
        try {
            return this.dynamoDbClient.describeTable(request).table().tableStatus();
        }
        catch (ResourceNotFoundException e) {
            logger.info("Table {} does not exist: creating it", (Object)tableName);
            return null;
        }
    }
}

