/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.aws.lambda.resources;

import com.cloudera.naaf.resources.AbstractResourceDownloader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AwsS3ResourceDownloader
extends AbstractResourceDownloader {
    private static final Logger logger = LoggerFactory.getLogger(AwsS3ResourceDownloader.class);
    private static final String STORAGE_BUCKET_ENV_VAR = "STORAGE_BUCKET";

    public void download(String sourceDirectory, File downloadDirectory) {
        String bucketName = System.getenv(STORAGE_BUCKET_ENV_VAR);
        String bucketPrefix = sourceDirectory.endsWith("/") ? sourceDirectory : sourceDirectory + "/";
        S3Client s3 = (S3Client)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build())).build();
        ListObjectsRequest listObjectsRequest = (ListObjectsRequest)ListObjectsRequest.builder().bucket(bucketName).prefix(bucketPrefix).build();
        ListObjectsResponse response = s3.listObjects(listObjectsRequest);
        int downloadCount = 0;
        List objects = response.contents();
        boolean isTruncated = false;
        do {
            for (S3Object object : objects) {
                isTruncated = response.isTruncated();
                String key = object.key();
                Long size = object.size();
                String filenameWithinSourceDir = AwsS3ResourceDownloader.substringAfter((String)key, (String)bucketPrefix);
                Path filePath = this.getDownloadPath(filenameWithinSourceDir, downloadDirectory);
                if (filePath == null) continue;
                logger.info("Downloading {} to {}", (Object)key, (Object)filePath);
                GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(key).build();
                try (ResponseInputStream responseInputStream = s3.getObject(getObjectRequest);){
                    Files.copy((InputStream)responseInputStream, filePath, new CopyOption[0]);
                }
                catch (IOException e) {
                    logger.error("Failed to download {}", (Object)key, (Object)e);
                    throw new RuntimeException(String.format("Failed to download %s to %s", key, filePath));
                }
                logger.debug("Downloaded {} ({} bytes)", (Object)filePath, (Object)size);
                ++downloadCount;
            }
            if (!isTruncated) continue;
            String nextMarker = response.nextMarker();
            listObjectsRequest = (ListObjectsRequest)ListObjectsRequest.builder().bucket(bucketName).prefix(bucketPrefix).marker(nextMarker).build();
            response = s3.listObjects(listObjectsRequest);
            objects = response.contents();
        } while (isTruncated);
        if (downloadCount == 0) {
            logger.debug("Found no objects in {}/{}", (Object)bucketName, (Object)bucketPrefix);
        }
    }
}

