/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.gcp.cloud.functions;

import com.cloudera.naaf.StatelessNiFiStateProvider;
import com.google.api.core.ApiFuture;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirestoreStatelessNiFiStateProvider
implements StatelessNiFiStateProvider {
    private static final Logger logger = LoggerFactory.getLogger(FirestoreStatelessNiFiStateProvider.class);
    public static final String DEFAULT_STATE_COLLECTION = "nifi_state";
    public static final String INSTANCE_ID = "instanceId";
    public static final String SCOPE = "scope";
    public static final String STATE = "state";
    public static final String FIRESTORE_STATE_COLLECTION = "FIRESTORE_STATE_COLLECTION";
    public static final String PROJECT_ID_VAR = "GCP_PROJECT";
    private final String collection;
    private Firestore firestore;

    public FirestoreStatelessNiFiStateProvider() {
        String projectId = System.getenv(PROJECT_ID_VAR);
        this.collection = Optional.ofNullable(System.getenv(FIRESTORE_STATE_COLLECTION)).orElse(DEFAULT_STATE_COLLECTION);
        try {
            FirestoreOptions firestoreOptions = ((FirestoreOptions.Builder)((FirestoreOptions.Builder)FirestoreOptions.getDefaultInstance().toBuilder().setProjectId(projectId)).setCredentials((Credentials)GoogleCredentials.getApplicationDefault())).build();
            this.firestore = (Firestore)firestoreOptions.getService();
        }
        catch (IOException e) {
            logger.error("Could not create Firestore Client", (Throwable)e);
            throw new RuntimeException("Could not create Firestore Client", e);
        }
    }

    public void storeState(String instanceId, StatelessNiFiStateProvider.StateScope scope, Map<String, String> state) {
        DocumentReference document = this.firestore.collection(this.collection).document(this.getDocumentId(instanceId, scope));
        document.set(state);
    }

    public Map<String, String> retrieveState(String instanceId, StatelessNiFiStateProvider.StateScope scope) {
        String documentId = this.getDocumentId(instanceId, scope);
        DocumentReference document = this.firestore.collection(this.collection).document(documentId);
        ApiFuture documentSnapshot = document.get();
        try {
            Map state = ((DocumentSnapshot)documentSnapshot.get()).getData();
            if (state == null) {
                logger.info("State attribute has not been stored for {}, scope {}", (Object)instanceId, (Object)scope);
                return null;
            }
            HashMap<String, String> stateMap = new HashMap<String, String>();
            state.forEach((key, value) -> stateMap.put((String)key, value.toString()));
            return stateMap;
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Could not retrieve state from Firestore for document {}", (Object)documentId);
            throw new RuntimeException("Could not retrieve state from Firestore for document " + documentId);
        }
    }

    private String getDocumentId(String instanceId, StatelessNiFiStateProvider.StateScope scope) {
        return instanceId + "-" + scope;
    }
}

