/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.gcp.cloud.functions.resources;

import com.cloudera.naaf.resources.AbstractResourceDownloader;
import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.File;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcpCloudStorageResourceDownloader
extends AbstractResourceDownloader {
    private static final Logger logger = LoggerFactory.getLogger(GcpCloudStorageResourceDownloader.class);
    private static final String STORAGE_BUCKET_ENV_VAR = "STORAGE_BUCKET";

    public void download(String sourceDirectory, File downloadDirectory) {
        String bucketName = System.getenv(STORAGE_BUCKET_ENV_VAR);
        String bucketPrefix = sourceDirectory.endsWith("/") ? sourceDirectory : sourceDirectory + "/";
        Storage storage = (Storage)StorageOptions.getDefaultInstance().getService();
        Page page = storage.list(bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)bucketPrefix)});
        int downloadCount = 0;
        do {
            for (Blob blob : page.getValues()) {
                String blobName = blob.getName();
                String filenameWithinSourceDir = GcpCloudStorageResourceDownloader.substringAfter((String)blobName, (String)bucketPrefix);
                Path filePath = this.getDownloadPath(filenameWithinSourceDir, downloadDirectory);
                if (filePath == null) continue;
                logger.info("Downloading {} to {}", (Object)blobName, (Object)filePath);
                blob.downloadTo(filePath);
                ++downloadCount;
            }
        } while ((page = page.getNextPage()) != null);
        if (downloadCount == 0) {
            logger.debug("Found no blobs in {}/{}", (Object)bucketName, (Object)bucketPrefix);
        }
    }
}

