/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.Schema;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;

final class AutoValue_QueryResponse
extends QueryResponse {
    private final Schema schema;
    private final boolean completed;
    private final long totalRows;
    private final ImmutableList<BigQueryError> errors;

    private AutoValue_QueryResponse(@Nullable Schema schema, boolean completed, long totalRows, ImmutableList<BigQueryError> errors) {
        this.schema = schema;
        this.completed = completed;
        this.totalRows = totalRows;
        this.errors = errors;
    }

    @Override
    @Nullable
    Schema getSchema() {
        return this.schema;
    }

    @Override
    boolean getCompleted() {
        return this.completed;
    }

    @Override
    long getTotalRows() {
        return this.totalRows;
    }

    @Override
    ImmutableList<BigQueryError> getErrors() {
        return this.errors;
    }

    public String toString() {
        return "QueryResponse{schema=" + this.schema + ", completed=" + this.completed + ", totalRows=" + this.totalRows + ", errors=" + this.errors + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryResponse) {
            QueryResponse that = (QueryResponse)o;
            return (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema())) && this.completed == that.getCompleted() && this.totalRows == that.getTotalRows() && this.errors.equals(that.getErrors());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.schema == null ? 0 : this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= this.completed ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.totalRows >>> 32 ^ this.totalRows);
        h$ *= 1000003;
        return h$ ^= this.errors.hashCode();
    }

    static final class Builder
    extends QueryResponse.Builder {
        private Schema schema;
        private Boolean completed;
        private Long totalRows;
        private ImmutableList<BigQueryError> errors;

        Builder() {
        }

        @Override
        QueryResponse.Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        QueryResponse.Builder setCompleted(boolean completed) {
            this.completed = completed;
            return this;
        }

        @Override
        QueryResponse.Builder setTotalRows(long totalRows) {
            this.totalRows = totalRows;
            return this;
        }

        @Override
        QueryResponse.Builder setErrors(ImmutableList<BigQueryError> errors) {
            if (errors == null) {
                throw new NullPointerException("Null errors");
            }
            this.errors = errors;
            return this;
        }

        @Override
        QueryResponse build() {
            if (this.completed == null || this.totalRows == null || this.errors == null) {
                StringBuilder missing = new StringBuilder();
                if (this.completed == null) {
                    missing.append(" completed");
                }
                if (this.totalRows == null) {
                    missing.append(" totalRows");
                }
                if (this.errors == null) {
                    missing.append(" errors");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_QueryResponse(this.schema, this.completed, this.totalRows, this.errors);
        }
    }
}

