/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp;

import com.cloudera.cdp.CdpHTTPException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.shaded.com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class CdpServiceException
extends CdpHTTPException {
    private static final String UNKNOWN = "unknown";
    private static final long serialVersionUID = -875642837484022999L;
    private final Map<String, List<String>> responseHeaders;
    private final String statusCode;
    private final String statusMessage;
    private final String requestId;

    public CdpServiceException(String requestId, int httpCode, Map<String, List<String>> responseHeaders, String statusCode, String statusMessage) {
        super(httpCode, statusMessage);
        ValidationUtils.checkNotNullAndThrow(responseHeaders);
        this.responseHeaders = ImmutableMap.copyOf(responseHeaders);
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.requestId = requestId;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String toString() {
        return String.format("%s: %d: %s: %s %s", this.getClass().getName(), this.getHttpCode(), this.statusCode != null ? this.statusCode : UNKNOWN, this.statusMessage != null ? this.statusMessage : UNKNOWN, this.requestId != null ? this.requestId : UNKNOWN);
    }

    @Override
    public String getMessage() {
        return this.toString();
    }
}

