/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.shaded.com.google.common.base.Preconditions;

@SdkInternalApi
public class ValidationUtils {
    private ValidationUtils() {
    }

    public static void checkStateAndThrow(boolean expr) {
        try {
            Preconditions.checkState(expr);
        }
        catch (IllegalStateException e) {
            throw new CdpClientException("Illegal state");
        }
    }

    public static void checkArgumentAndThrow(boolean expr) {
        try {
            Preconditions.checkArgument(expr);
        }
        catch (IllegalArgumentException e) {
            throw new CdpClientException("Illegal argument");
        }
    }

    public static <T> T checkNotNullAndThrow(T ref) {
        try {
            return Preconditions.checkNotNull(ref);
        }
        catch (NullPointerException e) {
            throw new CdpClientException("Argument is null");
        }
    }
}

