/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.authentication;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.cloudera.cdp.shaded.com.google.common.collect.Maps;
import com.cloudera.cdp.shaded.org.apache.commons.codec.binary.Base64;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.ASN1OctetString;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.signers.Ed25519Signer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.TreeMap;

public class Signer {
    private static final String RSA_ALGORITHM = "RSA";
    private static final String RSA_AUTH_METHOD = "rsav1";
    private static final String RSA_SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String ED25519_ALGORITHM = "Ed25519";
    private static final String ED25519_AUTH_METHOD = "ed25519v1";
    private static final String ED25519_SIGNATURE_ALGORITHM = "Ed25519";
    private static final String ECDSA_ALGORITHM = "EC";
    private static final String ECDSA_AUTH_METHOD = "ecdsav1";
    private static final String ECDSA_SIGNATURE_ALGORITHM = "SHA512withECDSA";

    public String computeAuthHeader(String httpMethod, String contentType, String date, String path, String accessKeyId, PrivateKey privateKey) {
        String signatureString;
        String sigAlgo;
        String authMethod;
        ValidationUtils.checkNotNullAndThrow(httpMethod);
        ValidationUtils.checkNotNullAndThrow(contentType);
        ValidationUtils.checkNotNullAndThrow(date);
        ValidationUtils.checkNotNullAndThrow(path);
        ValidationUtils.checkNotNullAndThrow(accessKeyId);
        ValidationUtils.checkNotNullAndThrow(privateKey);
        switch (privateKey.getAlgorithm()) {
            case "RSA": {
                authMethod = RSA_AUTH_METHOD;
                sigAlgo = RSA_SIGNATURE_ALGORITHM;
                break;
            }
            case "Ed25519": {
                authMethod = ED25519_AUTH_METHOD;
                sigAlgo = "Ed25519";
                break;
            }
            case "EC": {
                authMethod = ECDSA_AUTH_METHOD;
                sigAlgo = ECDSA_SIGNATURE_ALGORITHM;
                break;
            }
            default: {
                throw new CdpClientException("Unsupported key algorithm: " + privateKey.getAlgorithm());
            }
        }
        byte[] bytesToSign = (httpMethod + "\n" + contentType + "\n" + date + "\n" + path + "\n" + authMethod).getBytes(StandardCharsets.UTF_8);
        try {
            byte[] sig;
            switch (sigAlgo) {
                case "SHA256withRSA": 
                case "SHA512withECDSA": {
                    Signature signature = Signature.getInstance(sigAlgo);
                    signature.initSign(privateKey);
                    signature.update(bytesToSign);
                    sig = signature.sign();
                    break;
                }
                case "Ed25519": {
                    PrivateKeyInfo info = PrivateKeyInfo.getInstance(privateKey.getEncoded());
                    ASN1OctetString asn1Seed = ASN1OctetString.getInstance(info.parsePrivateKey());
                    byte[] seed = asn1Seed.getOctets();
                    Ed25519Signer signer = new Ed25519Signer();
                    signer.init(true, new Ed25519PrivateKeyParameters(seed, 0));
                    signer.update(bytesToSign, 0, bytesToSign.length);
                    sig = signer.generateSignature();
                    break;
                }
                default: {
                    throw new CdpClientException("Unsupported key algorithm: " + privateKey.getAlgorithm());
                }
            }
            signatureString = Base64.encodeBase64URLSafeString(sig);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
        try {
            TreeMap<String, String> authParams = Maps.newTreeMap();
            authParams.put("access_key_id", accessKeyId);
            authParams.put("auth_method", authMethod);
            String encodedAuthParams = new ObjectMapper().writeValueAsString(authParams);
            return String.format("%s.%s", Base64.encodeBase64URLSafeString(encodedAuthParams.getBytes(StandardCharsets.UTF_8)), signatureString);
        }
        catch (JsonProcessingException e) {
            throw new CdpClientException("Error while building authentication header");
        }
    }
}

