/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.authentication.credentials;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.authentication.credentials.CdpCredentials;
import com.cloudera.cdp.authentication.credentials.CdpCredentialsProvider;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpCredentialsProviderChain
implements CdpCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CdpCredentialsProviderChain.class);
    private final List<CdpCredentialsProvider> credentialProviders = new LinkedList<CdpCredentialsProvider>();

    public CdpCredentialsProviderChain(CdpCredentialsProvider ... credentialProviders) {
        if (credentialProviders == null || credentialProviders.length == 0) {
            throw new IllegalArgumentException("No credentials providers specified");
        }
        for (CdpCredentialsProvider credentialsProvider : credentialProviders) {
            this.credentialProviders.add(credentialsProvider);
        }
    }

    @Override
    public CdpCredentials getCredentials() {
        for (CdpCredentialsProvider provider : this.credentialProviders) {
            LOG.debug("trying to load credentials profile for provider " + provider.toString());
            try {
                CdpCredentials credentials = provider.getCredentials();
                if (!credentials.isValid().booleanValue()) continue;
                return credentials;
            }
            catch (Exception e) {
                LOG.debug("Unable to load credentials for provider " + provider.toString() + ": " + e.getMessage());
            }
        }
        throw new CdpClientException("Unable to load credentials from provider files");
    }
}

