/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.authentication.credentials;

import com.cloudera.cdp.authentication.credentials.BasicCdpCredentials;
import com.cloudera.cdp.authentication.credentials.CdpCredentials;
import com.cloudera.cdp.authentication.credentials.CdpCredentialsProvider;
import com.cloudera.cdp.shaded.org.apache.commons.lang3.StringUtils;

public class CdpEnvironmentVariableCredentialsProvider
implements CdpCredentialsProvider {
    public static final String CDP_ACCESS_KEY_ID = "CDP_ACCESS_KEY_ID";
    public static final String CDP_PRIVATE_KEY = "CDP_PRIVATE_KEY";
    public static final String CDP_ACCESS_TOKEN = "CDP_ACCESS_TOKEN";

    @Override
    public CdpCredentials getCredentials() {
        String accessKeyId = System.getenv(CDP_ACCESS_KEY_ID);
        String privateKey = System.getenv(CDP_PRIVATE_KEY);
        String accessToken = System.getenv(CDP_ACCESS_TOKEN);
        accessKeyId = StringUtils.trim(accessKeyId);
        privateKey = StringUtils.trim(privateKey);
        accessToken = StringUtils.trim(accessToken);
        if (StringUtils.isNoneEmpty(accessKeyId, privateKey)) {
            return new BasicCdpCredentials(accessKeyId, privateKey);
        }
        if (StringUtils.isNoneEmpty(accessToken)) {
            return new BasicCdpCredentials(accessToken);
        }
        throw new IllegalArgumentException("Invalid values for credential environment variables CDP_ACCESS_KEY_ID, CDP_PRIVATE_KEY and CDP_ACCESS_TOKEN");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

