/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.authentication.credentials;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.authentication.credentials.BasicCdpCredentials;
import com.cloudera.cdp.authentication.credentials.CdpCredentials;
import com.cloudera.cdp.authentication.credentials.CdpCredentialsProvider;
import com.cloudera.cdp.shaded.com.google.common.annotations.VisibleForTesting;
import com.cloudera.cdp.shaded.javax.annotation.Nullable;
import com.cloudera.cdp.shaded.javax.ws.rs.core.UriBuilder;
import com.cloudera.cdp.shaded.org.apache.commons.lang3.StringUtils;
import fi.iki.elonen.NanoHTTPD;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpInteractiveLoginCredentialsProvider
implements CdpCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CdpInteractiveLoginCredentialsProvider.class);
    private static final Duration DEFAULT_LOGIN_TIMEOUT = Duration.ofMinutes(10L);
    private static final String DEFAULT_LOGIN_URL = "https://consoleauth.altus.cloudera.com/login";
    private static final String USE_DEFAULT_IDP = null;
    private static final int USE_RANDOM_UNUSED_PORT = 0;
    private static final byte[] CLOSE_BROWSER_HTML = "<!DOCTYPE html>\n<html>\n  <head>\n    <link rel=\"icon\" href=\"data:,\">\n    <meta charset=\"utf-8\" />\n  </head>\n  <body onload=\"window.close()\">\n    <p>It is safe to close your browser.</p>\n  </body>\n</html>".getBytes(StandardCharsets.UTF_8);
    private final String accountId;
    private final String idp;
    private final String loginUrl;
    private final Duration timeout;
    private int listeningPort;
    private CountDownLatch countDownLatch;
    private final Object lockObj = new Object();
    @VisibleForTesting
    volatile String error = null;
    @VisibleForTesting
    volatile String accessKeyId = null;
    @VisibleForTesting
    volatile String privateKey = null;

    public CdpInteractiveLoginCredentialsProvider(String accountId) {
        this(accountId, USE_DEFAULT_IDP);
    }

    public CdpInteractiveLoginCredentialsProvider(String accountId, @Nullable String identityProvider) {
        this(accountId, identityProvider, DEFAULT_LOGIN_URL, 0, DEFAULT_LOGIN_TIMEOUT);
    }

    public CdpInteractiveLoginCredentialsProvider(String accountId, @Nullable String identityProvider, String loginUrl, int port, Duration timeout) {
        this.accountId = ValidationUtils.checkNotNullAndThrow(accountId);
        this.idp = identityProvider;
        this.loginUrl = ValidationUtils.checkNotNullAndThrow(loginUrl);
        this.listeningPort = port;
        this.timeout = ValidationUtils.checkNotNullAndThrow(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CdpCredentials getCredentials() {
        if (StringUtils.isAnyEmpty(this.accessKeyId, this.privateKey)) {
            if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                throw new UnsupportedOperationException("Desktop browse is not supported.");
            }
            try {
                if (this.listeningPort == 0) {
                    this.listeningPort = CdpInteractiveLoginCredentialsProvider.findUnusedPort();
                }
                URI url = this.resolveLoginUrl();
                LOG.debug("Open browser to login: " + url.toString());
                Desktop.getDesktop().browse(url);
                this.runHttpServer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (StringUtils.isNoneEmpty(this.accessKeyId, this.privateKey)) {
                return new BasicCdpCredentials(this.accessKeyId, this.privateKey);
            }
        }
        throw new IllegalArgumentException("Login failed: missing access key id or private key.");
    }

    @VisibleForTesting
    URI resolveLoginUrl() {
        UriBuilder urlBuilder = UriBuilder.fromUri(this.loginUrl);
        urlBuilder = urlBuilder.queryParam("accountId", this.accountId);
        if (StringUtils.isNoneEmpty(this.idp)) {
            urlBuilder = urlBuilder.queryParam("idp", this.idp);
        }
        urlBuilder = urlBuilder.queryParam("returnUrl", String.format("http://localhost:%d/interactiveLogin", this.listeningPort));
        return urlBuilder.build(new Object[0]);
    }

    @VisibleForTesting
    void runHttpServer() throws IOException {
        this.countDownLatch = new CountDownLatch(1);
        HttpServer httpd = new HttpServer();
        httpd.start();
        LOG.debug("HTTPServer started.");
        try {
            try {
                boolean waitSucceeded = this.countDownLatch.await(this.timeout.getSeconds(), TimeUnit.SECONDS);
                LOG.debug("Request served: " + waitSucceeded);
                if (!waitSucceeded) {
                    throw new CdpClientException("Login Timeout");
                }
                if (this.error != null) {
                    throw new CdpClientException("Login failed: " + this.error);
                }
            }
            finally {
                httpd.stop();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static int findUnusedPort() throws IOException {
        ServerSocket s = new ServerSocket(0);
        int port = s.getLocalPort();
        s.close();
        return port;
    }

    private class HttpServer
    extends NanoHTTPD {
        public HttpServer() {
            super("localhost", CdpInteractiveLoginCredentialsProvider.this.listeningPort);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
            LOG.debug("Handle HTTP request: " + session.getUri());
            Object object = CdpInteractiveLoginCredentialsProvider.this.lockObj;
            synchronized (object) {
                List<String> privateKeys;
                List<String> accessKeyIds;
                Map<String, List<String>> params = session.getParameters();
                List<String> errors = params.get("error");
                if (errors != null && !errors.isEmpty()) {
                    CdpInteractiveLoginCredentialsProvider.this.error = errors.get(0);
                }
                if ((accessKeyIds = params.get("accessKeyId")) != null && !accessKeyIds.isEmpty()) {
                    CdpInteractiveLoginCredentialsProvider.this.accessKeyId = accessKeyIds.get(0);
                }
                if ((privateKeys = params.get("privateKey")) != null && !privateKeys.isEmpty()) {
                    CdpInteractiveLoginCredentialsProvider.this.privateKey = privateKeys.get(0);
                }
            }
            return this.newResponse();
        }

        private NanoHTTPD.Response newResponse() {
            return new NanoHTTPD.Response(NanoHTTPD.Response.Status.OK, "text/html", new ByteArrayInputStream(CLOSE_BROWSER_HTML), CLOSE_BROWSER_HTML.length){

                @Override
                public void close() throws IOException {
                    super.close();
                    CdpInteractiveLoginCredentialsProvider.this.countDownLatch.countDown();
                }
            };
        }
    }
}

