/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.authentication.credentials.profile;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.authentication.credentials.BasicCdpCredentials;
import com.cloudera.cdp.authentication.credentials.CdpCredentials;
import com.cloudera.cdp.authentication.credentials.profile.AllCdpProfiles;
import com.cloudera.cdp.authentication.credentials.profile.CdpProfile;
import com.cloudera.cdp.authentication.credentials.profile.CdpProfileFileLoader;
import com.cloudera.cdp.shaded.org.apache.commons.lang3.StringUtils;
import java.io.File;

@SdkInternalApi
public class CdpProfileConfigFile {
    private AllCdpProfiles allProfiles;

    public CdpProfileConfigFile() {
        this(CdpProfileConfigFile.getCdpCredentialsLocation());
    }

    public CdpProfileConfigFile(String filePath) {
        this(new File(ValidationUtils.checkNotNullAndThrow(filePath)));
    }

    public CdpProfileConfigFile(File file) {
        this.allProfiles = this.loadProfiles(ValidationUtils.checkNotNullAndThrow(file));
    }

    public CdpCredentials getCredentials(String profileName) {
        ValidationUtils.checkNotNullAndThrow(profileName);
        CdpProfile profile = this.allProfiles.getProfile(profileName);
        if (profile == null) {
            throw new CdpClientException("Unable to find profile named " + profileName);
        }
        String accessKeyId = profile.getCdpAccessKeyId();
        String privateKey = profile.getCdpPrivateKey();
        String accessToken = profile.getCdpAccessToken();
        if (StringUtils.isNoneEmpty(accessKeyId, privateKey)) {
            return new BasicCdpCredentials(accessKeyId, privateKey);
        }
        if (StringUtils.isNoneEmpty(accessToken)) {
            return new BasicCdpCredentials(accessToken);
        }
        throw new IllegalArgumentException("Invalid values for credential profile " + profileName);
    }

    private static File getCdpCredentialsLocation() {
        File credProfiles = new File(CdpProfileConfigFile.getCdpDirectory(), "credentials");
        if (credProfiles.exists() && credProfiles.isFile()) {
            return credProfiles;
        }
        return null;
    }

    private static File getCdpDirectory() {
        return new File(CdpProfileConfigFile.getHomeDirectory(), ".cdp");
    }

    private static String getHomeDirectory() {
        String userHomeDir = System.getProperty("user.home");
        if (userHomeDir == null) {
            throw new CdpClientException("Unable to load CDP profiles since user.home system property is not set");
        }
        return userHomeDir;
    }

    private AllCdpProfiles loadProfiles(File file) {
        return new CdpProfileFileLoader().loadProfiles(file);
    }
}

