/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.authentication.credentials.profile;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.authentication.credentials.profile.AllCdpProfiles;
import com.cloudera.cdp.authentication.credentials.profile.CdpProfile;
import com.cloudera.cdp.shaded.com.google.common.collect.ImmutableMap;
import com.cloudera.cdp.shaded.com.google.common.io.Closeables;
import com.cloudera.cdp.shaded.org.ini4j.Ini;
import com.cloudera.cdp.shaded.org.ini4j.Profile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

@SdkInternalApi
class CdpProfileFileLoader {
    CdpProfileFileLoader() {
    }

    AllCdpProfiles loadProfiles(File file) {
        ValidationUtils.checkNotNullAndThrow(file);
        if (!file.exists()) {
            throw new CdpClientException("Error loading CDP profile. CDP profile file not found at: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new CdpClientException("Error loading CDP profile. File is a directory " + file.getAbsolutePath());
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Ini ini = new Ini(is);
            AllCdpProfiles allCdpProfiles = this.loadProfiles(ini);
            return allCdpProfiles;
        }
        catch (IOException ioe) {
            throw new CdpClientException("Unable to load CDP profile specified at " + file.getAbsolutePath(), ioe);
        }
        finally {
            if (is != null) {
                Closeables.closeQuietly(is);
            }
        }
    }

    private AllCdpProfiles loadProfiles(Ini ini) throws IOException {
        ImmutableMap.Builder<String, CdpProfile> profilesByName = ImmutableMap.builder();
        for (String sectionName : ini.keySet()) {
            Profile.Section section = (Profile.Section)ini.get(sectionName);
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (String optionKey : section.keySet()) {
                mapBuilder.put(optionKey, section.get(optionKey));
            }
            profilesByName.put(sectionName, new CdpProfile(mapBuilder.build()));
        }
        return new AllCdpProfiles(profilesByName.build());
    }
}

