/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.client.CdpClientConfigurationBuilder;
import com.cloudera.cdp.http.RetryHandler;
import com.cloudera.cdp.shaded.com.google.common.base.Preconditions;
import com.cloudera.cdp.shaded.com.google.common.collect.ImmutableList;
import com.cloudera.cdp.shaded.com.google.common.collect.ImmutableMap;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CdpClientConfiguration {
    private final int maxConnections;
    private final Duration readTimeout;
    private final Duration connectionTimeout;
    private final Duration connectionMaxIdle;
    private final Duration validateAfterInactivity;
    private final RetryHandler retryHandler;
    private final String clientApplicationName;
    private final String proxyUri;
    private final String proxyUsername;
    private final String proxyPassword;
    private final boolean ignoreTls;
    private final ImmutableList<X509Certificate> trustedCertificates;
    private final Map<String, String> requestHeaders;

    public CdpClientConfiguration(CdpClientConfigurationBuilder builder) {
        Preconditions.checkNotNull(builder);
        this.maxConnections = builder.getMaxConnections();
        this.readTimeout = builder.getReadTimeout();
        this.connectionTimeout = builder.getConnectionTimeout();
        this.connectionMaxIdle = builder.getConnectionMaxIdle();
        this.validateAfterInactivity = builder.getValidateAfterInactivity();
        this.retryHandler = builder.getRetryHandler();
        this.clientApplicationName = builder.getClientApplicationName();
        this.proxyUri = builder.getProxyUri();
        this.proxyUsername = builder.getProxyUsername();
        this.proxyPassword = builder.getProxyPassword();
        this.ignoreTls = builder.getIgnoreTls();
        this.trustedCertificates = ImmutableList.copyOf(builder.getTrustedCertificates());
        this.requestHeaders = ImmutableMap.copyOf(builder.getRequestHeaders());
    }

    public CdpClientConfigurationBuilder toBuilder() {
        return CdpClientConfigurationBuilder.defaultBuilder().withMaxConnections(this.maxConnections).withReadTimeout(this.readTimeout).withConnectionTimeout(this.connectionTimeout).withConnectionMaxIdle(this.connectionMaxIdle).withValidateAfterInactivity(this.validateAfterInactivity).withRetryHandler(this.retryHandler).withClientApplicationName(this.clientApplicationName).withProxyUri(this.proxyUri).withProxyUsername(this.proxyUsername).withProxyPassword(this.proxyPassword).withIgnoreTls(this.ignoreTls).withTrustedCertificates(new ArrayList<X509Certificate>(this.trustedCertificates)).withRequestHeaders(new HashMap<String, String>(this.requestHeaders));
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Duration getConnectionMaxIdle() {
        return this.connectionMaxIdle;
    }

    public Duration getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public RetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public String getClientApplicationName() {
        return this.clientApplicationName;
    }

    public String getProxyUri() {
        return this.proxyUri;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public boolean getIgnoreTls() {
        return this.ignoreTls;
    }

    public List<X509Certificate> getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }
}

