/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.CdpHTTPException;
import com.cloudera.cdp.CdpServiceException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.client.BaseResponse;
import com.cloudera.cdp.client.CdpClientMiddleware;
import com.cloudera.cdp.client.CdpRequestContext;
import com.cloudera.cdp.client.CdpResponse;
import com.cloudera.cdp.client.ResourceResponse;
import com.cloudera.cdp.client.RestResponse;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.core.type.TypeReference;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.cloudera.cdp.shaded.com.google.common.collect.ImmutableList;
import com.cloudera.cdp.shaded.com.google.common.collect.ImmutableMap;
import com.cloudera.cdp.shaded.javax.ws.rs.ProcessingException;
import com.cloudera.cdp.shaded.javax.ws.rs.core.Response;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class CdpParseResponseMiddleware
implements CdpClientMiddleware {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final CdpClientMiddleware next;

    public CdpParseResponseMiddleware(CdpClientMiddleware next) {
        this.next = ValidationUtils.checkNotNullAndThrow(next);
    }

    @Override
    public <T extends BaseResponse> void invokeAPI(CdpRequestContext<T> context) {
        ValidationUtils.checkNotNullAndThrow(context);
        Response response = null;
        boolean shouldCloseResponse = true;
        try {
            this.next.invokeAPI(context);
            response = context.getRawResponse();
            ValidationUtils.checkNotNullAndThrow(response);
            T result = this.parse(context, response);
            shouldCloseResponse = !(result instanceof RestResponse);
            context.setRawResponse(null);
            context.setResponse(result);
        }
        catch (IllegalStateException e) {
            throw new CdpClientException(e.getMessage(), e);
        }
        finally {
            if (shouldCloseResponse && response != null) {
                response.close();
            }
        }
    }

    private <T extends BaseResponse> T parse(CdpRequestContext<T> context, Response response) {
        int httpCode = response.getStatusInfo().getStatusCode();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            ImmutableList.Builder listBuilder = new ImmutableList.Builder();
            for (Object o : (List)entry.getValue()) {
                listBuilder.add(String.valueOf(o));
            }
            mapBuilder.put(entry.getKey(), listBuilder.build());
        }
        ImmutableMap<String, List<String>> responseHeaders = mapBuilder.build();
        if (RestResponse.class.isAssignableFrom(context.getResponseType().getRawType())) {
            RestResponse restResponse = new RestResponse();
            restResponse.setHttpCode(httpCode);
            restResponse.setResponseHeaders(responseHeaders);
            restResponse.setResponse(response);
            return (T)restResponse;
        }
        if (ResourceResponse.class.isAssignableFrom(context.getResponseType().getRawType())) {
            ResourceResponse resourceResponse = new ResourceResponse();
            resourceResponse.setHttpCode(httpCode);
            resourceResponse.setResponseHeaders(responseHeaders);
            resourceResponse.setResponse(response);
            return (T)resourceResponse;
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            BaseResponse cdpResponse = (BaseResponse)response.readEntity(context.getResponseType());
            if (cdpResponse == null) {
                throw new CdpHTTPException(httpCode, "Invalid response from server");
            }
            cdpResponse.setHttpCode(httpCode);
            cdpResponse.setResponseHeaders(responseHeaders);
            return (T)cdpResponse;
        }
        return this.parseError(response, httpCode, responseHeaders);
    }

    private <T extends BaseResponse> T parseError(Response response, int httpCode, Map<String, List<String>> responseHeaders) {
        String requestId;
        Error error;
        String body;
        try {
            body = response.readEntity(String.class);
        }
        catch (ProcessingException | NullPointerException e) {
            throw new CdpHTTPException(httpCode, "Error reading message from server", e);
        }
        try {
            error = MAPPER.readValue(body, new ErrorReference());
            requestId = CdpResponse.getRequestId(responseHeaders);
        }
        catch (IOException | IllegalArgumentException | NullPointerException e) {
            throw new CdpHTTPException(httpCode, body);
        }
        String errorMessage = null;
        if (error.message != null) {
            errorMessage = error.message;
        } else if (error.error != null) {
            errorMessage = error.error;
        } else if (error.errorMessages != null) {
            errorMessage = String.join((CharSequence)" ", error.errorMessages);
        }
        throw new CdpServiceException(requestId, httpCode, responseHeaders, error.code, errorMessage);
    }

    private static class ErrorReference
    extends TypeReference<Error> {
        private ErrorReference() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    private static class Error {
        public String code;
        public String message;
        public String error;
        public List<String> errorMessages;

        private Error() {
        }
    }
}

