/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.client.CdpClientConfiguration;
import com.cloudera.cdp.client.ConnectionManagerFactory;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.databind.util.StdDateFormat;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.cloudera.cdp.shaded.javax.ws.rs.client.Client;
import com.cloudera.cdp.shaded.javax.ws.rs.client.ClientBuilder;
import com.cloudera.cdp.shaded.org.apache.http.conn.ConnectionKeepAliveStrategy;
import com.cloudera.cdp.shaded.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.cloudera.cdp.shaded.org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import com.cloudera.cdp.shaded.org.glassfish.jersey.client.ClientConfig;
import com.cloudera.cdp.shaded.org.glassfish.jersey.client.RequestEntityProcessing;

@SdkInternalApi
public class ClientFactory {
    private final ConnectionManagerFactory connectionManagerFactory = new ConnectionManagerFactory();

    public Client create(CdpClientConfiguration config) {
        ValidationUtils.checkNotNullAndThrow(config);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.setDateFormat(new StdDateFormat());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider(objectMapper);
        ConnectionKeepAliveStrategy keepAliveStrategy = null;
        if (config.getConnectionMaxIdle().toMillis() > 0L) {
            keepAliveStrategy = (response, context) -> {
                long maxIdleTime = config.getConnectionMaxIdle().toMillis();
                long duration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
                if (0L < duration && duration < maxIdleTime) {
                    return duration;
                }
                return maxIdleTime;
            };
        }
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(jsonProvider);
        clientConfig.connectorProvider(new ApacheConnectorProvider());
        clientConfig.property("jersey.config.apache.client.connectionManager", this.connectionManagerFactory.create(config));
        clientConfig.property("jersey.config.apache.client.keepAliveStrategy", keepAliveStrategy);
        clientConfig.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        clientConfig.property("jersey.config.client.proxy.uri", config.getProxyUri());
        clientConfig.property("jersey.config.client.proxy.username", config.getProxyUsername());
        clientConfig.property("jersey.config.client.proxy.password", config.getProxyPassword());
        Client client = ClientBuilder.newBuilder().withConfig(clientConfig).build();
        client.property("jersey.config.client.readTimeout", (int)config.getReadTimeout().toMillis());
        client.property("jersey.config.client.connectTimeout", (int)config.getConnectionTimeout().toMillis());
        return client;
    }
}

