/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.shaded.com.google.common.collect.ImmutableList;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import com.cloudera.cdp.shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.List;

public class CredentialUtilities {
    private static final String RSA_ALGORITHM = "RSA";
    private static final String ECDSA_ALGORITHM = "EC";
    private static final List<String> POSSIBLE_PEM_PRIVATE_KEY_ALGORITHMS = ImmutableList.of("RSA", "EC");
    private static final int ED25519_KEY_LENGTH = 44;

    private CredentialUtilities() {
    }

    public static PrivateKey decodePrivateKey(String privateKey) {
        ValidationUtils.checkNotNullAndThrow(privateKey);
        if (privateKey.length() == 44) {
            return CredentialUtilities.decodeEd25519PrivateKey(privateKey);
        }
        return CredentialUtilities.decodePEMPrivateKey(privateKey);
    }

    /*
     * Exception decompiling
     */
    private static PrivateKey decodePEMPrivateKey(String privateKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 15[UNCONDITIONALDOLOOP], 0[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PrivateKey decodeEd25519PrivateKey(String privateKey) {
        byte[] seed = Base64.getDecoder().decode(privateKey);
        try {
            Ed25519PrivateKeyParameters params = new Ed25519PrivateKeyParameters(seed, 0);
            PrivateKeyInfo info = PrivateKeyInfoFactory.createPrivateKeyInfo(params);
            return new KeyFactorySpi.Ed25519().generatePrivate(info);
        }
        catch (IOException e) {
            throw new CdpClientException("Unable to generate private key " + e.getMessage(), e);
        }
    }
}

