/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.extension;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.client.BaseResponse;
import com.cloudera.cdp.client.CdpClientMiddleware;
import com.cloudera.cdp.client.CdpRequestContext;
import com.cloudera.cdp.df.model.ImportFlowDefinitionRequest;
import com.cloudera.cdp.df.model.ImportFlowDefinitionResponse;
import com.cloudera.cdp.df.model.ImportFlowDefinitionVersionRequest;
import com.cloudera.cdp.df.model.ImportFlowDefinitionVersionResponse;
import com.cloudera.cdp.dfworkload.model.UploadAssetRequest;
import com.cloudera.cdp.dfworkload.model.UploadAssetResponse;
import com.cloudera.cdp.shaded.com.google.common.base.Strings;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;

@SdkInternalApi
public class Df
implements CdpClientMiddleware {
    private final CdpClientMiddleware next;

    public Df(CdpClientMiddleware next) {
        this.next = ValidationUtils.checkNotNullAndThrow(next);
    }

    @Override
    public <T extends BaseResponse> void invokeAPI(CdpRequestContext<T> context) {
        ValidationUtils.checkNotNullAndThrow(context);
        if (context.getServiceName().equals("df") && context.getOperationName().equals("importFlowDefinition")) {
            this.dfImportFlowDefinition(context);
        } else if (context.getServiceName().equals("df") && context.getOperationName().equals("importFlowDefinitionVersion")) {
            this.dfImportFlowDefinitionVersion(context);
        } else if (context.getServiceName().equals("dfworkload") && context.getOperationName().equals("uploadAsset")) {
            this.dfWorkloadUploadAsset(context);
        } else {
            throw new CdpClientException(String.format("The operation is not supported. service name: %s, operation name: %s", context.getServiceName(), context.getOperationName()));
        }
    }

    private void dfImportFlowDefinition(CdpRequestContext<ImportFlowDefinitionResponse> context) {
        ImportFlowDefinitionRequest importFlowDefinitionRequest = (ImportFlowDefinitionRequest)context.getBody();
        String name = importFlowDefinitionRequest.getName();
        String description = importFlowDefinitionRequest.getDescription();
        String comments = importFlowDefinitionRequest.getComments();
        String filePath = importFlowDefinitionRequest.getFile();
        if (Strings.isNullOrEmpty(name)) {
            throw new CdpClientException("Name argument is null");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (name != null) {
            headers.put("Flow-Definition-Name", name);
        }
        if (description != null) {
            headers.put("Flow-Definition-Description", description);
        }
        if (comments != null) {
            headers.put("Flow-Definition-Comments", comments);
        }
        try (FileInputStream body = new FileInputStream(filePath);){
            context.setRequestContentType("application/json");
            context.setHeaders(headers);
            context.setBody(body);
            this.next.invokeAPI(context);
        }
        catch (IOException ioe) {
            throw new CdpClientException("Unable to load file at " + filePath, ioe);
        }
    }

    private void dfImportFlowDefinitionVersion(CdpRequestContext<ImportFlowDefinitionVersionResponse> context) {
        ImportFlowDefinitionVersionRequest importFlowDefinitionVersionRequest = (ImportFlowDefinitionVersionRequest)context.getBody();
        String comments = importFlowDefinitionVersionRequest.getComments();
        String filePath = importFlowDefinitionVersionRequest.getFile();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (comments != null) {
            headers.put("Flow-Definition-Comments", comments);
        }
        try (FileInputStream body = new FileInputStream(filePath);){
            context.setRequestContentType("application/json");
            context.setHeaders(headers);
            context.setBody(body);
            this.next.invokeAPI(context);
        }
        catch (IOException ioe) {
            throw new CdpClientException("Unable to load file at " + filePath, ioe);
        }
    }

    private void dfWorkloadUploadAsset(CdpRequestContext<UploadAssetResponse> context) {
        UploadAssetRequest uploadAssetRequest = (UploadAssetRequest)context.getBody();
        String parameterGroup = uploadAssetRequest.getParameterGroup();
        String parameterName = uploadAssetRequest.getParameterName();
        String deploymentRequestCrn = uploadAssetRequest.getDeploymentRequestCrn();
        String deploymentName = uploadAssetRequest.getDeploymentName();
        String filePath = uploadAssetRequest.getFilePath();
        if (Strings.isNullOrEmpty(parameterGroup)) {
            throw new CdpClientException("ParameterGroup argument is null");
        }
        if (Strings.isNullOrEmpty(parameterName)) {
            throw new CdpClientException("ParameterName argument is null");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (parameterGroup != null) {
            headers.put("Parameter-Group", parameterGroup);
        }
        if (parameterName != null) {
            headers.put("Parameter-Name", parameterName);
        }
        if (deploymentRequestCrn != null) {
            headers.put("Deployment-Request-Crn", deploymentRequestCrn);
        }
        if (deploymentName != null) {
            headers.put("Deployment-Name", deploymentName);
        }
        if (filePath != null) {
            headers.put("File-Path", filePath);
        }
        try (FileInputStream body = new FileInputStream(filePath);){
            context.setPath("/dfx/api/rpc-v1/deployments/upload-asset-content");
            context.setRequestContentType("application/octet-stream");
            context.setHeaders(headers);
            context.setBody(body);
            this.next.invokeAPI(context);
        }
        catch (IOException ioe) {
            throw new CdpClientException("Unable to load file at " + filePath, ioe);
        }
    }
}

