/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.http;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.http.DelayPolicy;
import com.cloudera.cdp.http.RetryChecker;
import com.cloudera.cdp.http.RetryHandler;
import java.time.Duration;

public class SimpleRetryHandler
implements RetryHandler {
    private final RetryChecker retryChecker;
    private final DelayPolicy delayPolicy;
    private final int maxAttempts;

    public SimpleRetryHandler(RetryChecker retryChecker, DelayPolicy delayPolicy, int maxAttempts) {
        this.retryChecker = ValidationUtils.checkNotNullAndThrow(retryChecker);
        this.delayPolicy = ValidationUtils.checkNotNullAndThrow(delayPolicy);
        ValidationUtils.checkArgumentAndThrow(maxAttempts > 0);
        this.maxAttempts = maxAttempts;
    }

    @Override
    public Duration shouldRetry(int attempts, CdpClientException exception) {
        ValidationUtils.checkNotNullAndThrow(exception);
        ValidationUtils.checkArgumentAndThrow(attempts >= 1);
        if (attempts < this.maxAttempts && this.retryChecker.shouldRetry(attempts, exception)) {
            return this.getDelay(attempts);
        }
        return DO_NOT_RETRY;
    }

    private Duration getDelay(int attempts) {
        ValidationUtils.checkArgumentAndThrow(attempts >= 1);
        return this.delayPolicy.delay(attempts);
    }
}

