/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.shaded.com.fasterxml.jackson.datatype.jsr310.deser;

import com.cloudera.cdp.shaded.com.fasterxml.jackson.core.JsonParser;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.core.JsonToken;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Year;
import java.time.format.DateTimeFormatter;

public class YearDeserializer
extends JSR310DateTimeDeserializerBase<Year> {
    private static final long serialVersionUID = 1L;
    public static final YearDeserializer INSTANCE = new YearDeserializer();

    private YearDeserializer() {
        this((DateTimeFormatter)null);
    }

    public YearDeserializer(DateTimeFormatter formatter) {
        super(Year.class, formatter);
    }

    protected YearDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new YearDeserializer(dtf);
    }

    protected YearDeserializer withLeniency(Boolean leniency) {
        return this;
    }

    @Override
    public Year deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String string = parser.getValueAsString().trim();
            try {
                if (this._formatter == null) {
                    return Year.parse(string);
                }
                return Year.parse(string, this._formatter);
            }
            catch (DateTimeException e) {
                return (Year)this._handleDateTimeException(context, e, string);
            }
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return Year.of(parser.getIntValue());
        }
        if (t == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return (Year)parser.getEmbeddedObject();
        }
        if (parser.hasToken(JsonToken.START_ARRAY)) {
            return (Year)this._deserializeFromArray(parser, context);
        }
        return (Year)this._handleUnexpectedToken(context, parser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT);
    }
}

