/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.shaded.org.bouncycastle.crypto.agreement.kdf;

import com.cloudera.cdp.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.DERNull;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.DEROctetString;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.DERSequence;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.DERTaggedObject;
import com.cloudera.cdp.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.DataLengthException;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.DerivationParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.Digest;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.DigestDerivationFunction;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.params.KDFParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.util.Pack;
import java.io.IOException;

public class ECDHKEKGenerator
implements DigestDerivationFunction {
    private DigestDerivationFunction kdf;
    private ASN1ObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        this.kdf = new KDF2BytesGenerator(digest);
    }

    public void init(DerivationParameters derivationParameters) {
        DHKDFParameters dHKDFParameters = (DHKDFParameters)derivationParameters;
        this.algorithm = dHKDFParameters.getAlgorithm();
        this.keySize = dHKDFParameters.getKeySize();
        this.z = dHKDFParameters.getZ();
    }

    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    public int generateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("output buffer too small");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new AlgorithmIdentifier(this.algorithm, DERNull.INSTANCE));
        aSN1EncodableVector.add(new DERTaggedObject(true, 2, new DEROctetString(Pack.intToBigEndian(this.keySize))));
        try {
            this.kdf.init(new KDFParameters(this.z, new DERSequence(aSN1EncodableVector).getEncoded("DER")));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("unable to initialise kdf: " + iOException.getMessage());
        }
        return this.kdf.generateBytes(byArray, n, n2);
    }
}

