/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.shaded.org.bouncycastle.jce.provider;

import com.cloudera.cdp.shaded.org.bouncycastle.jce.X509LDAPCertStoreParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.util.Selector;
import com.cloudera.cdp.shaded.org.bouncycastle.util.StoreException;
import com.cloudera.cdp.shaded.org.bouncycastle.x509.X509CRLStoreSelector;
import com.cloudera.cdp.shaded.org.bouncycastle.x509.X509StoreParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.x509.X509StoreSpi;
import com.cloudera.cdp.shaded.org.bouncycastle.x509.util.LDAPStoreHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class X509StoreLDAPCRLs
extends X509StoreSpi {
    private LDAPStoreHelper helper;

    public void engineInit(X509StoreParameters x509StoreParameters) {
        if (!(x509StoreParameters instanceof X509LDAPCertStoreParameters)) {
            throw new IllegalArgumentException("Initialization parameters must be an instance of " + X509LDAPCertStoreParameters.class.getName() + ".");
        }
        this.helper = new LDAPStoreHelper((X509LDAPCertStoreParameters)x509StoreParameters);
    }

    public Collection engineGetMatches(Selector selector) throws StoreException {
        if (!(selector instanceof X509CRLStoreSelector)) {
            return Collections.EMPTY_SET;
        }
        X509CRLStoreSelector x509CRLStoreSelector = (X509CRLStoreSelector)selector;
        HashSet hashSet = new HashSet();
        if (x509CRLStoreSelector.isDeltaCRLIndicatorEnabled()) {
            hashSet.addAll(this.helper.getDeltaCertificateRevocationLists(x509CRLStoreSelector));
        } else {
            hashSet.addAll(this.helper.getDeltaCertificateRevocationLists(x509CRLStoreSelector));
            hashSet.addAll(this.helper.getAttributeAuthorityRevocationLists(x509CRLStoreSelector));
            hashSet.addAll(this.helper.getAttributeCertificateRevocationLists(x509CRLStoreSelector));
            hashSet.addAll(this.helper.getAuthorityRevocationLists(x509CRLStoreSelector));
            hashSet.addAll(this.helper.getCertificateRevocationLists(x509CRLStoreSelector));
        }
        return hashSet;
    }
}

