/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.shaded.org.bouncycastle.math.ec.endo;

import com.cloudera.cdp.shaded.org.bouncycastle.math.ec.ECCurve;
import com.cloudera.cdp.shaded.org.bouncycastle.math.ec.ECPointMap;
import com.cloudera.cdp.shaded.org.bouncycastle.math.ec.ScaleYNegateXPointMap;
import com.cloudera.cdp.shaded.org.bouncycastle.math.ec.endo.EndoUtil;
import com.cloudera.cdp.shaded.org.bouncycastle.math.ec.endo.GLVEndomorphism;
import com.cloudera.cdp.shaded.org.bouncycastle.math.ec.endo.GLVTypeAParameters;
import java.math.BigInteger;

public class GLVTypeAEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeAParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeAEndomorphism(ECCurve eCCurve, GLVTypeAParameters gLVTypeAParameters) {
        this.parameters = gLVTypeAParameters;
        this.pointMap = new ScaleYNegateXPointMap(eCCurve.fromBigInteger(gLVTypeAParameters.getI()));
    }

    public BigInteger[] decomposeScalar(BigInteger bigInteger) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), bigInteger);
    }

    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    public boolean hasEfficientPointMap() {
        return true;
    }
}

