/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.shaded.org.bouncycastle.pqc.jcajce.provider.rainbow;

import com.cloudera.cdp.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.cloudera.cdp.shaded.org.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPrivateKey;
import com.cloudera.cdp.shaded.org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class RainbowKeysToParams {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof BCRainbowPublicKey) {
            BCRainbowPublicKey bCRainbowPublicKey = (BCRainbowPublicKey)publicKey;
            return new RainbowPublicKeyParameters(bCRainbowPublicKey.getDocLength(), bCRainbowPublicKey.getCoeffQuadratic(), bCRainbowPublicKey.getCoeffSingular(), bCRainbowPublicKey.getCoeffScalar());
        }
        throw new InvalidKeyException("can't identify Rainbow public key: " + publicKey.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCRainbowPrivateKey) {
            BCRainbowPrivateKey bCRainbowPrivateKey = (BCRainbowPrivateKey)privateKey;
            return new RainbowPrivateKeyParameters(bCRainbowPrivateKey.getInvA1(), bCRainbowPrivateKey.getB1(), bCRainbowPrivateKey.getInvA2(), bCRainbowPrivateKey.getB2(), bCRainbowPrivateKey.getVi(), bCRainbowPrivateKey.getLayers());
        }
        throw new InvalidKeyException("can't identify Rainbow private key.");
    }
}

