/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.shaded.org.glassfish.jersey.apache.connector;

import com.cloudera.cdp.shaded.javax.ws.rs.client.Client;
import com.cloudera.cdp.shaded.javax.ws.rs.core.Configurable;
import com.cloudera.cdp.shaded.javax.ws.rs.core.Configuration;
import com.cloudera.cdp.shaded.org.apache.http.client.CookieStore;
import com.cloudera.cdp.shaded.org.apache.http.client.HttpClient;
import com.cloudera.cdp.shaded.org.glassfish.jersey.apache.connector.ApacheConnector;
import com.cloudera.cdp.shaded.org.glassfish.jersey.apache.connector.LocalizationMessages;
import com.cloudera.cdp.shaded.org.glassfish.jersey.client.Initializable;
import com.cloudera.cdp.shaded.org.glassfish.jersey.client.spi.Connector;
import com.cloudera.cdp.shaded.org.glassfish.jersey.client.spi.ConnectorProvider;

public class ApacheConnectorProvider
implements ConnectorProvider {
    @Override
    public Connector getConnector(Client client, Configuration runtimeConfig) {
        return new ApacheConnector(client, runtimeConfig);
    }

    public static HttpClient getHttpClient(Configurable<?> component) {
        return ApacheConnectorProvider.getConnector(component).getHttpClient();
    }

    public static CookieStore getCookieStore(Configurable<?> component) {
        return ApacheConnectorProvider.getConnector(component).getCookieStore();
    }

    private static ApacheConnector getConnector(Configurable<?> component) {
        if (!(component instanceof Initializable)) {
            throw new IllegalArgumentException(LocalizationMessages.INVALID_CONFIGURABLE_COMPONENT_TYPE(component.getClass().getName()));
        }
        Initializable initializable = (Initializable)((Object)component);
        Connector connector = initializable.getConfiguration().getConnector();
        if (connector == null) {
            initializable.preInitialize();
            connector = initializable.getConfiguration().getConnector();
        }
        if (connector instanceof ApacheConnector) {
            return (ApacheConnector)connector;
        }
        throw new IllegalArgumentException(LocalizationMessages.EXPECTED_CONNECTOR_PROVIDER_NOT_USED());
    }
}

