/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.shaded.org.glassfish.jersey.message.internal;

import com.cloudera.cdp.shaded.javax.inject.Singleton;
import com.cloudera.cdp.shaded.javax.ws.rs.Consumes;
import com.cloudera.cdp.shaded.javax.ws.rs.Produces;
import com.cloudera.cdp.shaded.javax.ws.rs.core.MediaType;
import com.cloudera.cdp.shaded.javax.ws.rs.core.MultivaluedMap;
import com.cloudera.cdp.shaded.org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import com.cloudera.cdp.shaded.org.glassfish.jersey.message.internal.ReaderWriter;
import com.cloudera.cdp.shaded.org.glassfish.jersey.message.internal.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Produces(value={"application/octet-stream", "*/*"})
@Consumes(value={"application/octet-stream", "*/*"})
@Singleton
public final class FileProvider
extends AbstractMessageReaderWriterProvider<File> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class == type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File readFrom(Class<File> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        File file = Utils.createTempFile();
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            FileProvider.writeTo(entityStream, stream);
        }
        return file;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(File t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(t), ReaderWriter.BUFFER_SIZE);){
            FileProvider.writeTo(stream, entityStream);
        }
    }

    @Override
    public long getSize(File t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return t.length();
    }
}

