/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf;

import com.cloudera.naaf.metering.MeteringException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.stateless.flow.TriggerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessNiFiUtil {
    private static final Logger logger = LoggerFactory.getLogger(StatelessNiFiUtil.class);

    private StatelessNiFiUtil() {
    }

    public static void handleTriggerResult(TriggerResult triggerResult) {
        Throwable failure;
        if (triggerResult.isSuccessful()) {
            logger.debug("Dataflow completed successfully");
            triggerResult.acknowledge();
            logger.debug("Acknowledged trigger result{}", (Object)(triggerResult.getFailureCause().isPresent() ? " despite failure" : ""));
        }
        Throwable throwable = failure = !triggerResult.isSuccessful() ? new RuntimeException("Failed to execute dataflow") : (Throwable)triggerResult.getFailureCause().orElse(null);
        if (failure != null) {
            Throwable exception;
            Throwable throwable2 = exception = failure instanceof RuntimeException ? failure : new RuntimeException("Failed to execute dataflow", failure);
            if (failure instanceof MeteringException) {
                logger.error(failure.getMessage());
            } else {
                logger.error("Failure in the dataflow", exception);
            }
            throw exception;
        }
    }

    public static void copyOutput(FlowFile outputFlowfile, TriggerResult triggerResult, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream must be provided");
        }
        if (outputFlowfile == null) {
            logger.debug("No Output FlowFile so will not write any content to the output stream");
        } else {
            try (InputStream flowFileContent = triggerResult.readContent(outputFlowfile);){
                long numBytes = StatelessNiFiUtil.copy(flowFileContent, outputStream);
                logger.debug("Wrote {} bytes to the output stream from the Output FlowFile's contents", (Object)numBytes);
            }
        }
    }

    public static void logClassLoader(String message, ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            logger.debug("ClassLoader {} is {} (with parent {}) has the following URLs available: {}", message, urlClassLoader, urlClassLoader.getParent(), Arrays.asList(urlClassLoader.getURLs()));
        } else {
            logger.debug("The {} ClassLoader {} is {} (with parent {})", message, classLoader, classLoader.getParent());
        }
    }

    private static long copy(InputStream in, OutputStream out) throws IOException {
        int len;
        long totalBytes = 0L;
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
            totalBytes += (long)len;
        }
        return totalBytes;
    }
}

