/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.gcp.cloud.functions;

import com.cloudera.naaf.StatelessNiFiUtil;
import com.cloudera.naaf.gcp.cloud.functions.StatelessNiFiGcpFunctionHolder;
import com.google.cloud.functions.Context;
import com.google.cloud.functions.RawBackgroundFunction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.stateless.flow.TriggerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessNiFiBackgroundFunction
implements RawBackgroundFunction {
    private static final Logger logger = LoggerFactory.getLogger(StatelessNiFiBackgroundFunction.class);
    private static final String ATTRIBUTE_PREFIX = "gcp.context.";
    private static final AtomicReference<StatelessNiFiGcpFunctionHolder> functionHolderReference = new AtomicReference();

    @Override
    public void accept(String input, Context context) throws Exception {
        StatelessNiFiGcpFunctionHolder functionHolder = this.getFunctionHolder();
        logger.debug("Triggering background function...");
        Map<String, String> attributes = this.getAttributes(context);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            String instanceId = functionHolder.getFunctionName();
            TriggerResult triggerResult = functionHolder.getStatelessNiFiFunction().trigger(instanceId, bais, attributes);
            StatelessNiFiUtil.handleTriggerResult(triggerResult);
        }
    }

    private StatelessNiFiGcpFunctionHolder getFunctionHolder() throws IOException {
        StatelessNiFiGcpFunctionHolder functionHolder = functionHolderReference.get();
        if (functionHolder == null) {
            logger.debug("Function has not been initialized yet, initializing now...");
            functionHolder = new StatelessNiFiGcpFunctionHolder();
            functionHolderReference.set(functionHolder);
            logger.debug("Successfully initialized Background Function");
            return functionHolder;
        }
        logger.debug("Function is already initialized");
        return functionHolder;
    }

    private Map<String, String> getAttributes(Context context) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (context.attributes() != null) {
            context.attributes().forEach((key, value) -> attributes.put("gcp.context.attributes." + key, (String)value));
        }
        attributes.put("cloud.provider", "GCP");
        attributes.put("gcp.context.eventId", context.eventId());
        attributes.put("gcp.context.eventType", context.eventType());
        attributes.put("gcp.context.resource", context.resource());
        attributes.put("gcp.context.timestamp", context.timestamp());
        return attributes;
    }
}

