/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.gcp.cloud.functions;

import com.cloudera.naaf.StandardStatelessNiFiFunction;
import com.cloudera.naaf.StatelessFunctionConfiguration;
import com.cloudera.naaf.StatelessNiFiFunction;
import com.cloudera.naaf.metering.CloudPlatform;
import java.io.File;
import java.io.IOException;
import java.util.Optional;

public class StatelessNiFiGcpFunctionHolder {
    private static final File RESOURCES_DIRECTORY = new File(StatelessNiFiFunction.TEMP_DIR, "resources");
    private static final String FUNCTION_NAME_ENV_VAR = "K_SERVICE";
    private static final String FUNCTION_VERSION_ENV_VAR = "K_REVISION";
    private static final String STORAGE_EXTENSIONS_DIRECTORY_ENV_VAR = "STORAGE_EXTENSIONS_DIRECTORY";
    private static final String STORAGE_RESOURCES_DIRECTORY_ENV_VAR = "STORAGE_RESOURCES_DIRECTORY";
    private static final String STORAGE_BUCKET_ENV_VAR = "STORAGE_BUCKET";
    private static final String RESOURCE_DOWNLOADER_TYPE = "com.cloudera.naaf.gcp.cloud.functions.resources.GcpCloudStorageResourceDownloader";
    private static final String STATE_PROVIDER_TYPE = "com.cloudera.naaf.gcp.cloud.functions.FirestoreStatelessNiFiStateProvider";
    private static final String REGION = "REGION";
    private static final String DEFAULT_STORAGE_EXTENSIONS_DIRECTORY = "extensions";
    private static final String DEFAULT_STORAGE_RESOURCES_DIRECTORY = "resources";
    static final String GCP_CLOUD_PROVIDER = "GCP";
    private final StatelessNiFiFunction statelessNiFiFunction;
    private final String functionName = System.getenv("K_SERVICE");

    public StatelessNiFiGcpFunctionHolder() throws IOException {
        String functionVersion = System.getenv(FUNCTION_VERSION_ENV_VAR);
        String region = System.getenv(REGION);
        File resourcesDirectory = RESOURCES_DIRECTORY;
        if (!resourcesDirectory.exists() && !resourcesDirectory.mkdirs()) {
            throw new IOException("Resources directory " + resourcesDirectory.getAbsolutePath() + " does not exist and cannot be created");
        }
        String extensionsBucketDirectory = null;
        String resourcesBucketDirectory = null;
        String bucketName = System.getenv(STORAGE_BUCKET_ENV_VAR);
        if (bucketName != null) {
            extensionsBucketDirectory = Optional.ofNullable(System.getenv(STORAGE_EXTENSIONS_DIRECTORY_ENV_VAR)).orElse(DEFAULT_STORAGE_EXTENSIONS_DIRECTORY);
            resourcesBucketDirectory = Optional.ofNullable(System.getenv(STORAGE_RESOURCES_DIRECTORY_ENV_VAR)).orElse(DEFAULT_STORAGE_RESOURCES_DIRECTORY);
        }
        StatelessFunctionConfiguration configurationActions = new StatelessFunctionConfiguration.Builder().systemClassLoader(this.getClass().getClassLoader()).cloudPlatform(CloudPlatform.GOOGLE_CLOUD_FUNCTIONS).resourcesDirectory(resourcesDirectory).resourcesSourceDirectory(resourcesBucketDirectory).extensionsSourceDirectory(extensionsBucketDirectory).resourceDownloaderType(RESOURCE_DOWNLOADER_TYPE).stateProviderType(STATE_PROVIDER_TYPE).region(region).build();
        StandardStatelessNiFiFunction statelessNiFiFunction = new StandardStatelessNiFiFunction(this.functionName, functionVersion, configurationActions);
        this.statelessNiFiFunction = statelessNiFiFunction;
    }

    public StatelessNiFiFunction getStatelessNiFiFunction() {
        return this.statelessNiFiFunction;
    }

    public void finalize() {
        this.statelessNiFiFunction.cleanUp();
    }

    String getFunctionName() {
        return this.functionName;
    }
}

