/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.gcp.cloud.functions;

import com.cloudera.naaf.StatelessNiFiFunction;
import com.cloudera.naaf.StatelessNiFiUtil;
import com.cloudera.naaf.gcp.cloud.functions.StatelessNiFiGcpFunctionHolder;
import com.google.cloud.functions.HttpFunction;
import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.stateless.flow.TriggerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessNiFiHttpFunction
implements HttpFunction {
    private static final Logger logger = LoggerFactory.getLogger(StatelessNiFiHttpFunction.class);
    private static final String HEADER_ATTRIBUTE_PATTERN_ENV_VAR = "HEADER_ATTRIBUTE_PATTERN";
    private static final String HTTP_STATUS_CODE_ATTRIBUTE_ENV_VAR = "HTTP_STATUS_CODE_ATTRIBUTE";
    private static final String MIME_TYPE = "mime.type";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String RESPONSE_IO_ERROR_MSG = "Could not write HTTP Response";
    private static final String ATTRIBUTE_PREFIX = "gcp.http.header.";
    private static final int STATUS_OK = 200;
    private static final int STATUS_INTERNAL_SERVER_ERROR = 500;
    private static final AtomicReference<StatelessNiFiGcpFunctionHolder> functionHolderReference = new AtomicReference();
    private final Pattern headerAttributePattern;

    public StatelessNiFiHttpFunction() {
        String headerAttributePatternVariable = System.getenv(HEADER_ATTRIBUTE_PATTERN_ENV_VAR);
        this.headerAttributePattern = headerAttributePatternVariable == null ? null : Pattern.compile(headerAttributePatternVariable);
    }

    @Override
    public void service(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        StatelessNiFiGcpFunctionHolder functionHolder = this.getFunctionHolder();
        StatelessNiFiFunction statelessNiFiFunction = functionHolder.getStatelessNiFiFunction();
        try {
            logger.debug("Triggering HTTP Function");
            String instanceId = functionHolder.getFunctionName();
            TriggerResult triggerResult = statelessNiFiFunction.trigger(instanceId, httpRequest.getInputStream(), this.getAttributes(httpRequest));
            logger.debug("Triggered HTTP Function, successful = {}", (Object)triggerResult.isSuccessful());
            if (triggerResult.isSuccessful()) {
                Map<String, String> attributes;
                FlowFile outputFlowFile = statelessNiFiFunction.getOutputFlowfile(triggerResult);
                Map<String, String> map = attributes = outputFlowFile == null ? null : outputFlowFile.getAttributes();
                if (attributes == null) {
                    this.writeDefaultHttpResponse(httpResponse);
                } else {
                    this.prepareHttpResponse(httpResponse, attributes);
                    StatelessNiFiUtil.copyOutput(outputFlowFile, triggerResult, httpResponse.getOutputStream());
                }
            } else {
                logger.error("Trigger dataflow but received a failure result", (Throwable)triggerResult.getFailureCause().orElse(null));
                throw triggerResult.getFailureCause().orElse(new RuntimeException("DataFlow failed"));
            }
            triggerResult.acknowledge();
            logger.debug("Acknowledged Trigger Result");
        }
        catch (Throwable t) {
            logger.error("Failed to execute dataflow", t);
            this.writeErrorHttpResponse(httpResponse, t);
        }
    }

    private StatelessNiFiGcpFunctionHolder getFunctionHolder() throws IOException {
        StatelessNiFiGcpFunctionHolder functionHolder = functionHolderReference.get();
        if (functionHolder == null) {
            logger.debug("Function has not been initialized yet, initializing now...");
            functionHolder = new StatelessNiFiGcpFunctionHolder();
            functionHolderReference.set(functionHolder);
            return functionHolder;
        }
        logger.debug("Function already initialized.");
        return functionHolder;
    }

    private Map<String, String> getAttributes(HttpRequest httpRequest) {
        Map<String, String> attributes = httpRequest.getHeaders().entrySet().stream().filter(entry -> httpRequest.getFirstHeader((String)entry.getKey()).isPresent()).collect(Collectors.toMap(entry -> ATTRIBUTE_PREFIX + (String)entry.getKey(), entry -> httpRequest.getFirstHeader((String)entry.getKey()).get()));
        if (httpRequest.getContentType().isPresent()) {
            attributes.put(MIME_TYPE, httpRequest.getContentType().get());
        }
        attributes.put("cloud.provider", "GCP");
        attributes.put("gcp.http.method", httpRequest.getMethod());
        return attributes;
    }

    private void prepareHttpResponse(HttpResponse httpResponse, Map<String, String> outputAttributes) {
        String httpStatusCodeAttribute;
        int statusCode = 200;
        if (outputAttributes.containsKey(MIME_TYPE)) {
            httpResponse.setContentType(outputAttributes.get(MIME_TYPE));
        }
        if ((httpStatusCodeAttribute = System.getenv(HTTP_STATUS_CODE_ATTRIBUTE_ENV_VAR)) != null) {
            String statusCodeValue = outputAttributes.get(httpStatusCodeAttribute);
            logger.debug("HTTP Status Code Value = {}", (Object)statusCodeValue);
            if (statusCodeValue != null) {
                try {
                    int parsedStatusCode = Integer.parseInt(statusCodeValue);
                    if (parsedStatusCode < 100 || parsedStatusCode >= 600) {
                        String errorMessage = String.format("Invalid HTTP status code [%s] provided in [%s] attribute", parsedStatusCode, httpStatusCodeAttribute);
                        logger.error(errorMessage);
                        throw new IllegalArgumentException(errorMessage);
                    }
                    statusCode = parsedStatusCode;
                }
                catch (NumberFormatException e) {
                    String errorMessage = String.format("Could not parse HTTP status code attribute [%s] value", httpStatusCodeAttribute);
                    logger.error(errorMessage, e);
                    throw new RuntimeException(errorMessage, e);
                }
            }
        }
        if (this.headerAttributePattern != null) {
            outputAttributes.entrySet().stream().filter(entry -> this.headerAttributePattern.matcher((CharSequence)entry.getKey()).matches()).forEach(entry -> httpResponse.appendHeader((String)entry.getKey(), (String)entry.getValue()));
        }
        httpResponse.setStatusCode(statusCode);
    }

    private void writeDefaultHttpResponse(HttpResponse httpResponse) {
        try (OutputStream output = httpResponse.getOutputStream();){
            httpResponse.setStatusCode(200);
            httpResponse.setContentType(TEXT_PLAIN);
            output.write("DataFlow completed successfully".getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.error(RESPONSE_IO_ERROR_MSG, e);
            throw new RuntimeException(RESPONSE_IO_ERROR_MSG, e);
        }
    }

    private void writeErrorHttpResponse(HttpResponse httpResponse, Throwable t) {
        try (OutputStream output = httpResponse.getOutputStream();){
            httpResponse.setStatusCode(500);
            httpResponse.setContentType(TEXT_PLAIN);
            output.write(("DataFlow failure: " + t.getMessage()).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.error(RESPONSE_IO_ERROR_MSG, e);
            throw new RuntimeException(RESPONSE_IO_ERROR_MSG, e);
        }
    }
}

