/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.designer;

import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.designer.FlowComponentId;
import org.apache.nifi.designer.FlowDesignerClientInitializationContext;
import org.apache.nifi.designer.FlowRevisionStatus;
import org.apache.nifi.designer.event.EventContainer;
import org.apache.nifi.designer.event.change.FlowChangeErrorEvent;
import org.apache.nifi.designer.event.change.FlowChangeEvent;
import org.apache.nifi.designer.event.control.FlowControlEvent;
import org.apache.nifi.designer.event.feedback.BulletinGroup;
import org.apache.nifi.designer.event.feedback.ProcessGroupRemotePorts;
import org.apache.nifi.designer.event.feedback.VersionedControllerServiceStatus;
import org.apache.nifi.designer.event.feedback.VersionedControllerServiceStatuses;
import org.apache.nifi.designer.event.feedback.VersionedProcessGroupStatus;
import org.apache.nifi.designer.validation.ProcessGroupValidation;
import org.apache.nifi.flow.ComponentType;

public interface FlowDesignerClient {
    public void initialize(FlowDesignerClientInitializationContext var1);

    public String getClusterId();

    public String getNodeId();

    public String getControlChannel();

    public String getControlChannelInitialOffset();

    public Duration getStatusChannelPublishInterval();

    public Duration getBulletinChannelPublishInterval();

    public Duration getValidationChannelPublishInterval();

    public Duration getRemotePortsChannelPublishInterval();

    public void registerNode();

    public Optional<EventContainer<FlowControlEvent>> getNextFlowControlEvent(String var1, String var2);

    public Optional<EventContainer<FlowChangeEvent>> getNextFlowChangeEvent(String var1, String var2);

    public void publishFlowChangeEvent(String var1, FlowChangeEvent var2);

    public void publishFlowChangeError(FlowChangeErrorEvent var1);

    public void publishFlowRevisionStatus(FlowRevisionStatus var1);

    public void publishProcessGroupValidation(String var1, ProcessGroupValidation var2);

    public void publishProcessGroupStatus(String var1, VersionedProcessGroupStatus var2);

    public void publishControllerServiceStatus(String var1, VersionedControllerServiceStatus var2);

    public void publishControllerServiceStatuses(String var1, VersionedControllerServiceStatuses var2);

    public void publishProcessGroupRemotePorts(String var1, ProcessGroupRemotePorts var2);

    public void publishBulletins(String var1, BulletinGroup var2);

    public void publishComponentId(FlowComponentId var1);

    public void removeComponentId(String var1, ComponentType var2, String var3);

    public Set<FlowComponentId> getFlowComponentIds(String var1);

    public void shutdown();

    public void removeNode();
}

