/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.designer.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EventValidationResult {
    private final boolean valid;
    private final Set<String> invalidReasons = new HashSet<String>();
    private static final EventValidationResult VALID_RESULT = new EventValidationResult(true);

    private EventValidationResult(boolean valid, Set<String> invalidReasons) {
        this.valid = valid;
        this.invalidReasons.addAll(invalidReasons);
    }

    private EventValidationResult(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Set<String> getInvalidReasons() {
        return this.invalidReasons;
    }

    public static EventValidationResult valid() {
        return VALID_RESULT;
    }

    public static EventValidationResult invalid(String reason) {
        return new EventValidationResult(false, Collections.singleton(reason));
    }

    public static EventValidationResult invalid(Set<String> reasons) {
        return new EventValidationResult(false, reasons);
    }
}

