/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.designer.event.change;

import java.util.HashSet;
import org.apache.nifi.designer.event.AbstractFlowDesignerEvent;
import org.apache.nifi.designer.event.EventValidationResult;
import org.apache.nifi.designer.event.change.FlowChangeEventType;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.VersionedComponent;

public class FlowChangeEvent<VC extends VersionedComponent>
extends AbstractFlowDesignerEvent {
    private String flowId;
    private Long flowRevision;
    private Long componentRevision;
    private String clientId;
    private String lastModifier;
    private FlowChangeEventType eventType;
    private ComponentType componentType;
    private String batchId;
    private Integer batchCount = 1;
    private String requestId;
    private VC componentConfiguration;
    private FlowChangeSource source;

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public Long getFlowRevision() {
        return this.flowRevision;
    }

    public void setFlowRevision(Long flowRevision) {
        this.flowRevision = flowRevision;
    }

    public FlowChangeSource getSource() {
        return this.source;
    }

    public void setSource(FlowChangeSource source) {
        this.source = source;
    }

    public FlowChangeEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(FlowChangeEventType eventType) {
        this.eventType = eventType;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public void setComponentType(ComponentType componentType) {
        this.componentType = componentType;
    }

    public VC getComponentConfiguration() {
        return this.componentConfiguration;
    }

    public void setComponentConfiguration(VC componentConfiguration) {
        this.componentConfiguration = componentConfiguration;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public Integer getBatchCount() {
        return this.batchCount;
    }

    public void setBatchCount(Integer batchCount) {
        this.batchCount = batchCount;
    }

    public Long getComponentRevision() {
        return this.componentRevision;
    }

    public void setComponentRevision(Long componentRevision) {
        this.componentRevision = componentRevision;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Override
    public final EventValidationResult validate() {
        HashSet<String> invalidReasons = new HashSet<String>();
        if (this.isBlank(this.getEventId())) {
            invalidReasons.add("eventId is required");
        }
        if (this.isBlank(this.flowId)) {
            invalidReasons.add("flowId is required");
        }
        if (this.flowRevision == null) {
            invalidReasons.add("revision is required");
        }
        if (this.eventType == null) {
            invalidReasons.add("eventType is required");
        }
        if (this.componentType == null) {
            invalidReasons.add("componentType is required");
        }
        if (this.componentConfiguration == null) {
            invalidReasons.add("componentConfiguration is required");
        }
        if (this.batchCount == null) {
            invalidReasons.add("batchCount is required");
        }
        if (this.batchId == null) {
            invalidReasons.add("batchId is required");
        }
        if (this.source == null) {
            invalidReasons.add("source is required");
        }
        return invalidReasons.isEmpty() ? EventValidationResult.valid() : EventValidationResult.invalid(invalidReasons);
    }

    public String toString() {
        return "FlowChangeEvent[" + "eventId=" + this.getEventId() + ", " + "flowId=" + this.flowId + ", " + "flowRevision=" + this.flowRevision + ", " + "eventType=" + this.eventType.name() + ", " + "componentType=" + this.componentType.name() + ", " + "componentId=" + ((VersionedComponent)this.componentConfiguration).getIdentifier() + ", " + "batchId=" + this.batchId + ", " + "source=" + this.source.name() + "requestId=" + this.requestId + "]";
    }

    public static enum FlowChangeSource {
        NIFI,
        EXTERNAL,
        EXTERNAL_POSTPROCESSING_NIFI;

    }
}

