/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.designer.event.control;

import java.util.HashSet;
import java.util.List;
import org.apache.nifi.designer.event.EventValidationResult;
import org.apache.nifi.designer.event.control.FlowControlEvent;
import org.apache.nifi.designer.event.control.FlowControlEventType;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedProcessGroup;

public class FlowCreatedEvent
extends FlowControlEvent {
    private Long flowRevision;
    private String changeChannel;
    private String changeChannelOffset;
    private String opsChannel;
    private VersionedProcessGroup content;
    private List<VersionedParameterContext> parameterContexts;

    public Long getFlowRevision() {
        return this.flowRevision;
    }

    public void setFlowRevision(Long flowRevision) {
        this.flowRevision = flowRevision;
    }

    public String getChangeChannel() {
        return this.changeChannel;
    }

    public void setChangeChannel(String changeChannel) {
        this.changeChannel = changeChannel;
    }

    public String getChangeChannelOffset() {
        return this.changeChannelOffset;
    }

    public void setChangeChannelOffset(String changeChannelOffset) {
        this.changeChannelOffset = changeChannelOffset;
    }

    public String getOpsChannel() {
        return this.opsChannel;
    }

    public void setOpsChannel(String opsChannel) {
        this.opsChannel = opsChannel;
    }

    public VersionedProcessGroup getContent() {
        return this.content;
    }

    public void setContent(VersionedProcessGroup content) {
        this.content = content;
    }

    @Override
    public FlowControlEventType getEventType() {
        return FlowControlEventType.FLOW_CREATED;
    }

    public List<VersionedParameterContext> getParameterContexts() {
        return this.parameterContexts;
    }

    public void setParameterContexts(List<VersionedParameterContext> parameterContexts) {
        this.parameterContexts = parameterContexts;
    }

    @Override
    protected EventValidationResult validateAdditionalFields() {
        HashSet<String> invalidReasons = new HashSet<String>();
        if (this.flowRevision == null) {
            invalidReasons.add("flowRevision is required");
        }
        if (this.isBlank(this.changeChannel)) {
            invalidReasons.add("changeChannel is required");
        }
        if (this.isBlank(this.opsChannel)) {
            invalidReasons.add("opsChannel is required");
        }
        if (this.content == null) {
            invalidReasons.add("content is required");
        }
        return invalidReasons.isEmpty() ? EventValidationResult.valid() : EventValidationResult.invalid(invalidReasons);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + "eventId=" + this.getEventId() + ", " + "flowId=" + this.getFlowId() + ", " + "clusterId=" + this.getClusterId() + ", " + "eventType=" + this.getEventType().name() + ", " + "flowRevision=" + this.getFlowRevision() + ", " + "changeChannel=" + this.getChangeChannel() + ", " + "changeChannelOffset=" + this.getChangeChannelOffset() + "]";
    }
}

