/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.nar.NarManifestEntry;
import org.apache.nifi.util.StringUtils;

public class NarBundleUtil {
    public static BundleDetails fromNarDirectory(File narDirectory) throws IOException, IllegalStateException {
        if (narDirectory == null) {
            throw new IllegalArgumentException("NAR Directory cannot be null");
        }
        File manifestFile = new File(narDirectory, "META-INF/MANIFEST.MF");
        try (FileInputStream fis = new FileInputStream(manifestFile);){
            Manifest manifest = new Manifest(fis);
            Attributes attributes = manifest.getMainAttributes();
            BundleDetails.Builder builder = new BundleDetails.Builder();
            builder.workingDir(narDirectory);
            String group = attributes.getValue(NarManifestEntry.NAR_GROUP.getManifestName());
            String id = attributes.getValue(NarManifestEntry.NAR_ID.getManifestName());
            String version = attributes.getValue(NarManifestEntry.NAR_VERSION.getManifestName());
            builder.coordinate(new BundleCoordinate(group, id, version));
            String dependencyGroup = attributes.getValue(NarManifestEntry.NAR_DEPENDENCY_GROUP.getManifestName());
            String dependencyId = attributes.getValue(NarManifestEntry.NAR_DEPENDENCY_ID.getManifestName());
            String dependencyVersion = attributes.getValue(NarManifestEntry.NAR_DEPENDENCY_VERSION.getManifestName());
            if (!StringUtils.isBlank(dependencyId)) {
                builder.dependencyCoordinate(new BundleCoordinate(dependencyGroup, dependencyId, dependencyVersion));
            }
            builder.buildBranch(attributes.getValue(NarManifestEntry.BUILD_BRANCH.getManifestName()));
            builder.buildTag(attributes.getValue(NarManifestEntry.BUILD_TAG.getManifestName()));
            builder.buildRevision(attributes.getValue(NarManifestEntry.BUILD_REVISION.getManifestName()));
            builder.buildTimestamp(attributes.getValue(NarManifestEntry.BUILD_TIMESTAMP.getManifestName()));
            builder.buildJdk(attributes.getValue(NarManifestEntry.BUILD_JDK.getManifestName()));
            builder.builtBy(attributes.getValue(NarManifestEntry.BUILT_BY.getManifestName()));
            BundleDetails bundleDetails = builder.build();
            return bundleDetails;
        }
    }
}

