/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;

public final class SystemBundle {
    public static final BundleCoordinate SYSTEM_BUNDLE_COORDINATE = new BundleCoordinate("default", "system", "unversioned");

    public static Bundle create(NiFiProperties niFiProperties) {
        return SystemBundle.create(niFiProperties, ClassLoader.getSystemClassLoader());
    }

    public static Bundle create(NiFiProperties niFiProperties, ClassLoader systemClassLoader) {
        String narLibraryDirectory = niFiProperties.getProperty("nifi.nar.library.directory");
        return SystemBundle.create(narLibraryDirectory, systemClassLoader);
    }

    public static Bundle create(String narLibraryDirectory, ClassLoader systemClassLoader) {
        if (StringUtils.isBlank(narLibraryDirectory)) {
            throw new IllegalStateException("Unable to create system bundle because nifi.nar.library.directory was null or empty");
        }
        BundleDetails systemBundleDetails = new BundleDetails.Builder().workingDir(new File(narLibraryDirectory)).coordinate(SYSTEM_BUNDLE_COORDINATE).build();
        return new Bundle(systemBundleDetails, systemClassLoader);
    }
}

