/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.stateless.parameter.AbstractParameterValueProvider;
import org.apache.nifi.stateless.parameter.ParameterValueProvider;
import org.apache.nifi.stateless.parameter.ParameterValueProviderInitializationContext;

public abstract class AbstractSecretBasedParameterValueProvider
extends AbstractParameterValueProvider
implements ParameterValueProvider {
    private static final Validator NON_EMPTY_VALIDATOR = (subject, value, context) -> new ValidationResult.Builder().subject(subject).input(value).valid(value != null && !value.isEmpty()).explanation(subject + " cannot be empty").build();
    public static final PropertyDescriptor DEFAULT_SECRET_NAME = new PropertyDescriptor.Builder().displayName("Default Secret Name").name("default-secret-name").description("The default secret name to use.  This secret represents a default Parameter Context if there is not a matching key within the mapped Parameter Context secret").addValidator(NON_EMPTY_VALIDATOR).build();
    private List<PropertyDescriptor> descriptors;
    private String defaultSecretName = null;
    private Map<String, String> contextToSecretMapping;

    protected abstract List<PropertyDescriptor> getAdditionalSupportedPropertyDescriptors();

    protected abstract void additionalInit(ParameterValueProviderInitializationContext var1);

    protected abstract String getSecretValue(String var1, String var2);

    @Override
    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().displayName(propertyDescriptorName).name(propertyDescriptorName).dynamic(true).addValidator(NON_EMPTY_VALIDATOR).build();
    }

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    @Override
    protected final void init(ParameterValueProviderInitializationContext context) {
        super.init(context);
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>(this.getAdditionalSupportedPropertyDescriptors());
        propertyDescriptors.add(DEFAULT_SECRET_NAME);
        this.descriptors = Collections.unmodifiableList(propertyDescriptors);
        this.defaultSecretName = context.getProperty(DEFAULT_SECRET_NAME).getValue();
        this.contextToSecretMapping = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : context.getAllProperties().entrySet()) {
            if (!this.getPropertyDescriptor(entry.getKey()).isDynamic()) continue;
            this.contextToSecretMapping.put(entry.getKey(), entry.getValue());
        }
        this.additionalInit(context);
    }

    @Override
    public boolean isParameterDefined(String contextName, String parameterName) {
        return this.getParameterValue(contextName, parameterName) != null;
    }

    @Override
    public String getParameterValue(String contextName, String parameterName) {
        String contextBasedValue = this.getSecretValue(this.getSecretName(contextName), parameterName);
        return contextBasedValue != null || this.defaultSecretName == null ? contextBasedValue : this.getSecretValue(this.defaultSecretName, parameterName);
    }

    private String getSecretName(String contextName) {
        return this.contextToSecretMapping.getOrDefault(contextName, contextName);
    }
}

