/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.BetaApi;
import com.google.auto.value.AutoValue;
import com.google.cloud.firestore.AutoValue_BulkWriterOptions;
import com.google.cloud.firestore.FirestoreException;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@BetaApi
@AutoValue
public abstract class BulkWriterOptions {
    public abstract boolean getThrottlingEnabled();

    @Nullable
    public abstract Double getInitialOpsPerSecond();

    @Nullable
    public abstract Double getMaxOpsPerSecond();

    @Nullable
    public abstract ScheduledExecutorService getExecutor();

    public static Builder builder() {
        return new AutoValue_BulkWriterOptions.Builder().setMaxOpsPerSecond(null).setInitialOpsPerSecond(null).setThrottlingEnabled(true).setExecutor(null);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setThrottlingEnabled(boolean var1);

        abstract Builder setInitialOpsPerSecond(@Nullable Double var1);

        public Builder setInitialOpsPerSecond(int initialOpsPerSecond) {
            return this.setInitialOpsPerSecond(new Double(initialOpsPerSecond));
        }

        abstract Builder setMaxOpsPerSecond(@Nullable Double var1);

        public Builder setMaxOpsPerSecond(int maxOpsPerSecond) {
            return this.setMaxOpsPerSecond(new Double(maxOpsPerSecond));
        }

        public abstract Builder setExecutor(@Nullable ScheduledExecutorService var1);

        public abstract BulkWriterOptions autoBuild();

        @Nonnull
        public BulkWriterOptions build() {
            BulkWriterOptions options = this.autoBuild();
            Double initialRate = options.getInitialOpsPerSecond();
            Double maxRate = options.getMaxOpsPerSecond();
            if (initialRate != null && initialRate < 1.0) {
                throw FirestoreException.forInvalidArgument("Value for argument 'initialOpsPerSecond' must be greater than 1, but was: " + initialRate.intValue(), new Object[0]);
            }
            if (maxRate != null && maxRate < 1.0) {
                throw FirestoreException.forInvalidArgument("Value for argument 'maxOpsPerSecond' must be greater than 1, but was: " + maxRate.intValue(), new Object[0]);
            }
            if (maxRate != null && initialRate != null && initialRate > maxRate) {
                throw FirestoreException.forInvalidArgument("'maxOpsPerSecond' cannot be less than 'initialOpsPerSecond'.", new Object[0]);
            }
            if (!(options.getThrottlingEnabled() || maxRate == null && initialRate == null)) {
                throw FirestoreException.forInvalidArgument("Cannot set 'initialOpsPerSecond' or 'maxOpsPerSecond' when 'throttlingEnabled' is set to false.", new Object[0]);
            }
            return options;
        }
    }
}

